#
# Copyright 2001, 2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import Plugin, ExternalConverterBase
import os

class Converter(ExternalConverterBase):
  suffix = 'rtf'
  mime_type = 'application/rtf'

  def _convert(self):
    self._convertToHtml()
    self._convertToText()

  def _convertToHtml(self):
    cmd = "cd '%s' && unrtf '%s.%s' > '%s.html' 2> /dev/null" \
      % (self.tmpdir, self.name, self.suffix, self.name)
    os.system(cmd)

  #
  # Accessors to get results.
  #
  def getText(self):
    return open("%s/%s.txt" % (self.tmpdir, self.name)).read()

  def getHtml(self):
    data = open("%s/%s.html" % (self.tmpdir, self.name)).read()
    return data


p = Plugin('RTF', [Converter])
p.addAcceptableMimeType('text/rtf')
p.addAcceptableMimeType('application/rtf')
p.addAcceptableFileType('Rich Text Format data.*')
 
def getPlugin():
  return p

