#
# Copyright 2001, 2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#

#
# Register plugins
# 
# XXX: there should be some way to scan the plugins/ directory for plugins
# without explicitly listing them here.

import traceback, os, tempfile

#
# Dumb should always be last
#
_plugin_names = ['MSOffice', 'OpenOffice', 'PDF', 'RTF', 'Dumb']

class _PluginSelector:
  def __init__(self, plugin_names):
    self.plugins = []
    for name in plugin_names:
      self.loadPlugin(name)

  def loadPlugin(self, name):
    try:
      module = __import__(name, globals(), globals(), [])
      self.plugins.append(module.getPlugin())
    except:
      print "Error loading plugin %s" % name
      traceback.print_exc()

  def getDefaultPlugin(self):
    return self.plugins[-1]
    
  def selectPlugin(self, file, mime_type):
    if mime_type:
      plugin = self.selectPluginFromMimeType(mime_type)
      if plugin:
        return plugin
    plugin = self.selectPluginFromFile(file)
    if plugin:
      return plugin
    else:
      return self.getDefaultPlugin()

  def selectPluginFromMimeType(self, mime_type):
    for plugin in self.plugins:
      if plugin.acceptMimeType(mime_type):
        return plugin

  def selectPluginFromFile(self, file):
    tempname = tempfile.mktemp()
    open(tempname, 'wc').write(file)
    mime_type = os.popen('file -i %s 2>/dev/null' % tempname).read()
    os.unlink(tempname)
    for plugin in self.plugins:
      if plugin.acceptMimeType(mime_type):
        return plugin

    tempname = tempfile.mktemp()
    open(tempname, 'wc').write(file)
    file_type = os.popen('file %s 2>/dev/null' % tempname).read()
    os.unlink(tempname)
    for plugin in self.plugins:
      if plugin.acceptFileType(file_type):
        return plugin
    
_plugin_selector = _PluginSelector(_plugin_names)

# 
# Only these two functions are exported
#
def selectPlugin(file, mime_type=''):
  return _plugin_selector.selectPlugin(file, mime_type)

def getDefaultPlugin():
  return _plugin_selector.getDefaultPlugin()

