#!/usr/bin/python

#
# Copyright 2001 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
import sys, os, unittest
sys.path.insert(0, '..')
sys.path.insert(0, os.environ.get('ZOPE_HOME', '../../..')+'/lib/python/')
import Zope, Acquisition
import NuxDocument, CMFNuxDocument
from Testing import makerequest
import plugins, string, re

from AccessControl.SecurityManagement \
  import newSecurityManager, getSecurityManager

#
# This has been copied verbatim from CMFCore/tests/test_TypesTool.py
#
class UnitTestSecurityPolicy:
  "Stub out the existing security policy for unit testing purposes."
  #
  #   Standard SecurityPolicy interface
  #
  def validate(*args, **kw):
    return 1
  
  def checkPermission(*args, **kw):
    return 1

class UnitTestUser(Acquisition.Implicit):
  id = 'unit_tester'
  def getId(self):
    return 'unit_tester'

  getUserName = getId

  def allowed(self, object, object_roles=None):
    return 1

  def getRoles(self):
    return ['Manager']

###############################################################################

class BaseTestCase(unittest.TestCase):
  def setUp(self):
    self.app = makerequest.makerequest(Zope.app())
    get_transaction().begin()
    self.app.manage_addProduct['ZCatalog']\
      .manage_addZCatalog('Catalog', title='')
    self.catalog = self.app.Catalog

  def tearDown(self):
    get_transaction().abort()
    self.app._p_jar.close()


class DumbTestCase(BaseTestCase):
  def test_Dumb(self):
    title = 'XXX title YYY'
    data = 'qwreytroiquwe'
    self.app.manage_addProduct['NuxDocument']\
      .addZNuxDocument(id='doc', file=data, title=title)

    doc = self.app.doc
    self.assertEquals(doc.title, title)
    self.assertEquals(doc.getRaw(), data)

    #self.assertEquals(doc.mime_type, '???/???') # XXX: fix this


class MSWordTestCase(BaseTestCase):
  def setUp(self):
    BaseTestCase.setUp(self)
    self.data = open('test1.doc').read()
    self.doc = NuxDocument.NuxDocument(id='doc', file=self.data)

  def test1(self):
    pass


class ZMSWordTestCase(BaseTestCase):
  def setUp(self):
    BaseTestCase.setUp(self)
    self.data = open('test1.doc').read()
    self.app.manage_addProduct['NuxDocument']\
      .addZNuxDocument(id='doc', file=self.data)
    self.doc = self.app.doc

  def test_catalogSupport(self):
    data = self.doc.PrincipiaSearchSource()
    self.assertEquals(string.count(data, 'Linux'), 1)

  def test_catalog(self):
    brain_list = self.catalog(PrincipiaSearchSource='linux')
    self.assertEqual(len(brain_list), 1)

    brain_list = self.catalog(PrincipiaSearchSource='macos')
    self.assertEqual(len(brain_list), 0)

  def test_rawAccess(self):
    return
    data = self.doc.document_src()
    self.assertEqual(data, self.data)

    data = self.doc.manage_FTPget()
    self.assertEqual(data, self.data)

  def test_render(self):
    self.assertEquals(
      string.count(self.doc(), 'Linux'), 1)

    #data = self.doc.document_src(REQUEST, RESPONSE)
    #REQUEST, RESPONSE = self.app.REQUEST, self.app.REQUEST.RESPONSE
    #self.assertEqual(RESPONSE.getHeader('Content-Type'), self.doc.mime_type)

class ZMSWordImagesTestCase(BaseTestCase):
  def setUp(self):
    BaseTestCase.setUp(self)
    self.data = open('test4.doc').read()
    self.app.manage_addProduct['NuxDocument']\
      .addZNuxDocument(id='doc', file=self.data)
    self.doc = self.app.doc

  def test_image(self):
    img = self.doc['doc0.png']
    self.assertEquals(img.get_size(), 5690)

#
# CMFDocument tests
#

class CMFMSWordTestCase1(BaseTestCase):
  "Test CMFNuxDocument with a Word document, using direct objet instantiation"

  def setUp(self):
    BaseTestCase.setUp(self)
    self.data = open('test1.doc').read()
    self.doc = CMFNuxDocument.CMFNuxDocument(id='doc', file=self.data)

  def test_mime_type(self):
    self.assertEqual(self.doc.mime_type, 'application/msword')

  def test1(self):
    data = open('test2.doc').read()
    self.doc.edit('', file=data)

  def test_CookedBody(self):
    assert not re.search('<body(?i)', self.doc.CookedBody())


class CMFMSWordTestCase2(BaseTestCase):
  "Test CMFNuxDocument with a Word document, using CMF factory"

  def setUp( self ):
    from AccessControl import SecurityManager
    from Products.CMFCore import utils

    self.app = makerequest.makerequest(Zope.app())
    get_transaction().begin()
    self._policy = UnitTestSecurityPolicy()
    SecurityManager.setSecurityPolicy(self._policy)

    self.app.manage_addProduct['CMFDefault']\
      .manage_addCMFSite(id='cmf_unittest')
    self.cmf = self.app.cmf_unittest

    #
    # Setup Types Tools to recognize our new class
    #
    tt = utils.getToolByName(self.cmf, 'portal_types')
    tt.manage_addTypeInformation(
      id='NuxDocument', typeinfo_name='NuxDocument: CMFNuxDocument')
    self.assert_('NuxDocument' in tt.listContentTypes())

    self.cmf.invokeFactory('NuxDocument',
      id='doc', title='xxxtitleyyy')
    self.doc = self.cmf.doc

    self.data = open('test1.doc').read()
    self.doc._edit(title='xxxtitleyyy', file=self.data, mime_type='')

  def tearDown(self):
    get_transaction().abort()

  #def test_setup(self):
  #  "Check that the test setup is OK"
  #  self.cmf.invokeFactory('Document', id='doc_test', title='')

  def test_mime_type(self):
    self.assertEqual(self.doc.mime_type, 'application/msword')

  def test_portalCatalog(self):
    "Test that the right keywords are in the portal_catalog"
    words = map(lambda x: x[0], self.cmf.portal_catalog.Vocabulary.words())
    self.assert_('linux' in words)

    # XXX: works ok but we are left without a proper SecurityManager afterwards
    #newSecurityManager(None, UnitTestUser().__of__(self.app))
    #brain_list = self.cmf.portal_catalog(PrincipiaSearchSource='linux')
    #self.assertEqual(len(brain_list), 1)

def main():
  unittest.main(argv=['-v', '-v'])

if __name__ == '__main__':
  main()

