from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Products.Formulator.Form import FormValidationError

from Mailman import mm_cfg
from Mailman.UserDesc import UserDesc

import sha


class FormManager:
    ''' '''

    # XXX Comment these ones out, if you want to develop the zpt scripts over the ZMI

    manage_list_general   = PageTemplateFile('zpt/manage_list_general',
                                             globals(), __name__='manage_list_general')
    manage_list_passwords = PageTemplateFile('zpt/manage_list_passwords',
                                             globals(), __name__='manage_list_passwords')
    manage_list_languages = PageTemplateFile('zpt/manage_list_languages',
                                             globals(), __name__='manage_list_languages')
    manage_list_members   = PageTemplateFile('zpt/manage_list_members',
                                             globals(), __name__='manage_list_members')
    manage_list_digest    = PageTemplateFile('zpt/manage_list_digest',
                                             globals(), __name__='manage_list_digest')
    manage_list_nondigest = PageTemplateFile('zpt/manage_list_nondigest',
                                             globals(), __name__='manage_list_nondigest')
    manage_list_privacy   = PageTemplateFile('zpt/manage_list_privacy',
                                             globals(), __name__='manage_list_privacy')
    manage_list_bounce    = PageTemplateFile('zpt/manage_list_bounce',
                                             globals(), __name__='manage_list_bounce')
    manage_list_archive   = PageTemplateFile('zpt/manage_list_archive',
                                             globals(), __name__='manage_list_archive')
    manage_list_autoresp  = PageTemplateFile('zpt/manage_list_autoresp',
                                             globals(), __name__='manage_list_autoresp')
    manage_list_gateways  = PageTemplateFile('zpt/manage_list_gateways',
                                             globals(), __name__='manage_list_gateways')
    show_attribute_help   = PageTemplateFile('zpt/show_attribute_help',
                                             globals(), __name__='show_attribute_help')


    def manage_list_general_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.general_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_general(manage_tabs_message=message)


    def manage_list_passwords_action(self, REQUEST):
        ''' '''
        message = ''
        attrs = {}
        try:
            temp_attrs = self.passwords_form.validate_all(REQUEST)
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'
    
        if temp_attrs['admin_passwd'] != temp_attrs['admin_passwd_confirm']:
            message = 'Admin Password: The password and confirmation did not match!'
        elif temp_attrs['admin_passwd'] != '':
            attrs['password'] = sha.new(temp_attrs['admin_passwd']).hexdigest()

        if temp_attrs['moderator_passwd'] != temp_attrs['moderator_passwd_confirm']:
            message = 'Moderator Password: The password and confirmation did not match!'
        elif temp_attrs['moderator_passwd'] != '':
            attrs['mod_password'] = sha.new(temp_attrs['moderator_passwd']).hexdigest()

        if not message and attrs:
            self._save_attributes(attrs)
            message = "Saved changes."

        return self.manage_list_passwords(manage_tabs_message=message)


    def manage_list_languages_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.languages_form.validate_all(REQUEST)
            if attrs['preferred_language'] not in attrs['available_languages']:
                attrs['available_languages'].append(attrs['preferred_language'])
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_languages(manage_tabs_message=message)


    def get_available_languages_info(self):
        ''' '''
        return map(lambda lang, lc=mm_cfg.LC_DESCRIPTIONS: (lc[lang][0], lang),
                   self.available_languages)


    def manage_list_members_action(self, REQUEST):
        ''' '''
        option_map = {'mod':    128,
                      'hide':    16,
                      'plain':    8,
                      'ack':      4,
                      'notmetoo': 2,
                      'nomail':   1,
                      'digest':   0}

        if not self.get_list().Locked():
            self.get_list().Lock()

        for member in self.members.getMembers():
            if REQUEST.form.has_key(member+'_unsub'):
                self.members.removeMember(member)
            else:
                self.members.setMemberLanguage(member, REQUEST.form[member+'_language'])
                self.members.setMemberName(member, REQUEST.form[member+'_fullname'])
                for option in option_map.keys():
                    if (self.members.getMemberOption(member, option_map[option]) ^
                        REQUEST.form.has_key(member+'_'+option)):
                        self.members.setMemberOption(member, option_map[option], 1)

        self.get_list().Save()
        self.get_list().Unlock()

        return self.manage_list_members(manage_tabs_message='Saved Changes.')


    def get_sorted_members(self):
        ''' '''
        members = self.members.getMembers()
        members.sort()
        return members


    def manage_list_members_subscription(self, REQUEST):
        ''' '''
        try:
            attrs = self.members_form.validate_all(REQUEST)

            if not self.get_list().Locked():
                self.get_list().Lock()

            for address in attrs['address_list']:
                if (REQUEST.form.has_key('subscribe') and
                    address not in self.members.getMembers()): 
                    userdesc = UserDesc(address)
                    self.get_list().ApprovedAddMember(userdesc, ack=attrs['notify_member'],
                                                      admin_notif=attrs['notify_owner'])
                if (REQUEST.form.has_key('remove') and 
                    address in self.members.getMembers()): 
                    self.get_list().ApprovedDeleteMember(address,
                                                         admin_notif=attrs['notify_owner'],
                                                         userack=attrs['notify_member'])

            self.get_list().Save()
            self.get_list().Unlock()    

            message = "Mass Manipulation completed." 
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_members(manage_tabs_message=message)


    def manage_list_nondigest_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.nondigest_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_nondigest(manage_tabs_message=message)


    def manage_list_digest_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.digest_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_digest(manage_tabs_message=message)


    def manage_list_privacy_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.privacy_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_privacy(manage_tabs_message=message)


    def manage_list_bounce_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.bounce_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_bounce(manage_tabs_message=message)


    def manage_list_archive_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.archive_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_archive(manage_tabs_message=message)


    def manage_list_autoresp_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.autoresp_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_autoresp(manage_tabs_message=message)


    def manage_list_gateways_action(self, REQUEST):
        ''' '''
        try:
            attrs = self.gateways_form.validate_all(REQUEST)
            self._save_attributes(attrs)
            message = "Saved changes."
        except FormValidationError, e:
            message = ''
            for error in e.errors:
                message += error.field.id + ': ' + error.error_text + '<br>'

        return self.manage_list_gateways(manage_tabs_message=message)


    def _save_attributes(self, attrs):
        ''' '''
        if not self.get_list().Locked():
            self.get_list().Lock()
        try:
            for attr in attrs.keys():
                self[attr] = attrs[attr]
            self.get_list().Save()
        finally:
            self.get_list().Unlock()


    def get_attribute_info(self, fieldname):
        ''' '''
        # This import must be here, since otherwise the Formulator stuff
        # will not behave well.
        import ZMailListFields
        
        if fieldname in ZMailListFields.__dict__.keys():
            field = ZMailListFields.__dict__[fieldname]
            info = field.values
            info['id'] = field.id
            info['type'] = field.meta_type
            return info
        
        return None
        
