from ZMailList import ZMailList
from Mailman import Utils, MailList, mm_cfg, Message
import sys, os 

class ListManager:
    ''' '''

    def __list_bobo_traverse__(self, REQUEST, name=None):
        ''' '''
        return self.get_list(name)


    def __list_getattr__(self, name):
        ''' '''
        return self.get_list(name)


    def __list_getitem__(self, name):
        ''' '''
        return self.get_list(name)


    def get_list_names(self):
        ''' '''
        names = Utils.list_names()
        names.sort()
        return names


    def get_list(self, name):
        ''' '''
        if name in Utils.list_names():
            mlist = ZMailList(name)
            mlist = mlist.__of__(self)
            return mlist

        return None


    def get_lists(self):
        ''' '''
        lists = []
        for name in self.get_list_names():
            lists.append(self.get_list(name))
        return lists
                      

    def get_advertised_lists(self):
        ''' '''
        advertised = []
        for mlist in self.get_lists():
            if mlist.advertised:
                advertised.append(mlist)
        return advertised


    def add_list(self, name, owner_mail, password, quiet=0, **options):
        ''' '''
        if name in self.get_list_names():
            raise 'ListAlreadyExistsError', 'Foo'
        
        mlist = MailList.MailList()
        mlist.Create(name, owner_mail, password)

        if options.has_key('host_name'):
            mlist.host_name = options['host_name']
        if options.has_key('web_page_url'):
            mlist.web_page_url = options['web_page_url']

        mlist.Save()
        mlist.Unlock()

        # Now do the MTA-specific list creation tasks
        if mm_cfg.MTA:
            modname = 'Mailman.MTA.' + mm_cfg.MTA
            __import__(modname)
            sys.modules[modname].create(mlist)

        # And send the notice to the list owner
        if not quiet:
            siteadmin = Utils.get_site_email(mlist.host_name, 'admin')
            text = Utils.maketext(
                'newlist.txt',
                {'listname'    : name,
                 'password'    : password, 
                 'admin_url'   : mlist.GetScriptURL('admin', absolute=1), 
                 'listinfo_url': mlist.GetScriptURL('listinfo', absolute=1),
                 'requestaddr' : mlist.GetRequestEmail(),
                 'siteowner'   : siteadmin,
                 }, mlist.preferred_language)
            
            msg = Message.UserNotification(owner_mail, siteadmin,
                                           'Your new mailing list: %(listname)s',
                                           text)
            msg.send(mlist)


    def delete_list(self, name):
        ''' '''
        if name not in self.get_list_names():
            raise 'ListDoesNotExistError', 'Foo'

        os.system('rm -r %s' %os.path.join(mm_cfg.LIST_DATA_DIR, name))
        os.system('rm -r %s.*' %os.path.join(mm_cfg.PRIVATE_ARCHIVE_FILE_DIR, name))
        os.system('rm -r %s.*' %os.path.join(mm_cfg.PUBLIC_ARCHIVE_FILE_DIR, name))
        






