# This code is copyrighted by Stephan Richter in December, 2001.
#
# written by Stephan Richter
# Last updated: December 2, 2001

from Globals        import DTMLFile
from OFS.Folder     import Folder
from ExtensionClass import Base
from Products.PageTemplates.PageTemplateFile import PageTemplateFile


# Support classes
from ListManager   import ListManager
from ConfigManager import ConfigManager


manage_addMailmanFolderForm = PageTemplateFile('zpt/manage_addMailmanFolderForm', globals(),
                                               __name__='manage_addMailmanFolderForm')

def manage_addMailmanFolder(self, id, title='', REQUEST=None):
    ''' '''
    ob = MailmanFolder(id, title)
    self._setObject(id, ob)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)


class MailmanFolder(Folder, ListManager, ConfigManager):
    ''' '''

    meta_type = 'Mailman Folder'

    manage_options = ((Folder.manage_options[0],
                       {'label':'Default Settings', 'action':'manage_view_defaults'},
                       {'label':'List Admin', 'action':'manage_view_lists'},
                       {'label':'Look & Feel', 'action':'manage_look_and_feel'},                       
                       ))

    manage_view_defaults  = PageTemplateFile('zpt/manage_view_defaults',
                                    globals(), __name__='manage_view_defaults')
    manage_view_lists     = PageTemplateFile('zpt/manage_view_lists',
                                    globals(), __name__='manage_view_lists')
    #manage_look_and_feel = PageTemplateFile('zpt/manage_look_and_feel',
    #                                        globals(), __name__='manage_look_and_feel')

    __allow_access_to_unprotected_subobjects__ = 1


    def __init__(self, id, title=''):
        ''' '''
        self.id = id
        self.title = title


    def __bobo_traverse__(self, REQUEST, name=None):
        ''' '''

        if self.__list_bobo_traverse__(name):
            return self.__list_bobo_traverse__(name)

        if self.__config_bobo_traverse__(name):
            return self.__config_bobo_traverse__(name)

        return getattr(self, name)


    def __getattr__(self, name):
        ''' '''
        if self.__list_getattr__(name):
            return self.__list_getattr__(name)

        if self.__config_getattr__(name):
            return self.__config_getattr__(name)

        return Base.__getattr__(self, name)


    def __getitem__(self, name):
        ''' '''
        if self.__list_getitem__(name):
            return self.__list_getitem__(name)

        if self.__config_getitem__(name):
            return self.__config_getitem__(name)

        return getattr(self, name)


    def all_meta_types(self, interfaces=None):
        ''' '''
        import Products
        meta_type = []
        for mt in Products.meta_types:
            if mt['name'] == 'Mailing List':
                meta_type = mt
                break
            
        return [meta_type]


    def objectIds(self, spec=None):
        ''' '''
        return self.get_list_names()


    def _delOb(self, id):
        ''' '''
        if id in self.get_list_names():
            self.delete_list(id)


    def tpValues(self):
        ''' '''
        return self.get_lists()
