from AccessControl.User import BasicUserFolder, SimpleUser
from Mailman import Utils, MailList
from Products.PageTemplates.PageTemplateFile import PageTemplateFile


MODERATE     = 128
HIDDEN       = 16
PLAIN        = 8
ACKNOWLEDGE  = 4
GETOWNPOST   = 2
RECVNOMAIL   = 1
DIGEST       = 0


manage_addZMMUserFolderForm = PageTemplateFile('zpt/manage_addZMMUserFolderForm', globals(),
                                               __name__='manage_addZMMUserFolderForm')

def manage_addZMMUserFolder(self, listname='', REQUEST=None, **ignored):
    ''' '''
    ob = ZMMUserFolder(listname)

    self=self.this()
    try:    self._setObject('acl_users', ob)
    except: return MessageDialog(
                   title  ='Item Exists',
                   message='This object already contains a User Folder',
                   action ='%s/manage_main' % REQUEST['URL1'])

    self.__allow_groups__ = ob

    if REQUEST is not None:
        REQUEST['RESPONSE'].redirect(self.absolute_url()+'/manage_main')


class ZMMUserFolder(BasicUserFolder):
    ''' '''

    meta_type = 'Mailman User Folder'
    id        = 'acl_users'
    title     = 'Mailman User Folder'
    icon      = 'misc_/OFSP/UserFolder_icon.gif'


    def __init__(self, listname):
        ''' '''
        self.setListName(listname)


    def getListName(self):
        ''' '''
        return self.__listname


    def setListName(self, listname):
        ''' '''
        if listname in Utils.list_names():
            self.__listname = listname
            
    
    def getUserNames(self):
        """Return a list of usernames"""
        mlist = MailList.MailList(self.getListName(), lock=0)
        members = mlist._memberadaptor.getMembers()
        members.sort()
        return members


    def getUsers(self):
        """Return a list of user objects"""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor
        users = []
        for name in self.getUserNames():
            users.append(self.getUser(name))
        return users


    def getUser(self, name):
        """Return the named user object or None"""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor
        if name in adaptor.getMembers():
            user = ZMMUser(name).__of__(self)
            user.__ = user._getPassword()
            user.roles = user.getRoles()
            return user
        else:
            return None


    def _doAddUser(self, name, password, roles, domains, **kw):
        """Create a new user. This should be implemented by subclasses to
           do the actual adding of a user. The 'password' will be the
           original input password, unencrypted. The implementation of this
           method is responsible for performing any needed encryption."""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor
        adaptor.addNewMember(name, password=password)


    def _doChangeUser(self, name, password, roles, domains, **kw):
        """Modify an existing user. This should be implemented by subclasses 
           to make the actual changes to a user. The 'password' will be the
           original input password, unencrypted. The implementation of this
           method is responsible for performing any needed encryption."""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor
        adaptor.setMemberPassword(self, name, password)


    def _doDelUsers(self, names):
        """Delete one or more users. This should be implemented by subclasses
           to do the actual deleting of users."""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor
        adaptor.removeMember(name)


class ZMMUser(SimpleUser):
    ''' '''
            
    def __init__(self, name, password='', roles=[], domains=[]):
        ''' '''
        self.name = name


    def getUserName(self):
        """Return the username of a user"""
        return self.name


    def _getPassword(self):
        """Return the password of the user."""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor
        return adaptor.getMemberPassword(self.name)


    def getRoles(self):
        """Return the list of roles assigned to a user."""
        adaptor = MailList.MailList(self.getListName(), lock=0)._memberadaptor        
        
        # All roles will be generated based on your Mailman settings
        roles = ['SubscriberOf' + self.getListName()]    # Subscriber of List role
        if adaptor.getMemberOption(self.name, MODERATE):
            roles.append('ModeratedSubscr')
        if adaptor.getMemberOption(self.name, HIDDEN):
            roles.append('HiddenSubscr')
        if adaptor.getMemberOption(self.name, PLAIN):
            roles.append('PlainEMailsSubscr')
        if adaptor.getMemberOption(self.name, ACKNOWLEDGE):
            roles.append('RecvAckSubscr')
        if adaptor.getMemberOption(self.name, GETOWNPOST):
            roles.append('ModeratedSubscriber')
        if adaptor.getMemberOption(self.name, RECVNOMAIL):
            roles.append('SubscrRecvNoMail')
        if adaptor.getMemberOption(self.name, DIGEST):
            roles.append('DigestSubscr')

        return roles


    def getRolesInContext(self, object):
        """Return the list of roles assigned to the user,
           including local roles assigned in context of
           the passed in object."""
        return self.getRoles()


    def getDomains(self):
        """Return the list of domain restrictions for a user"""
        return []
