from OFS.Folder     import Folder
from ExtensionClass import Base
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
import DateTime

from FormManager import FormManager

from Mailman.MailList import MailList


manage_addMailListForm = PageTemplateFile('zpt/manage_addMailListForm',
                                          globals(),
                                          __name__='manage_addMailListForm')

def manage_addMailList(self, id, title='', REQUEST=None):
    ''' '''

    self.add_list(id, REQUEST['owner_mail'], REQUEST['password'])

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)


class ZMailList(FormManager, Folder):
    ''' '''

    meta_type = 'Mailing List'
    icon = 'misc_/ZMailman/MailList'
    
    manage_options = ( {'label':'Contents',      'action':'manage_main'},
                       {'label':'General',       'action':'manage_list_general'},
                       {'label':'Passwords',     'action':'manage_list_passwords'},
                       {'label':'Languages',     'action':'manage_list_languages'},
                       {'label':'Members',       'action':'manage_list_members'},
                       {'label':'Non-Digest',    'action':'manage_list_nondigest'},
                       {'label':'Digest',        'action':'manage_list_digest'},
                       {'label':'Privacy',       'action':'manage_list_privacy'},                       
                       {'label':'Bounce',        'action':'manage_list_bounce'},                       
                       {'label':'Archive',       'action':'manage_list_archive'},                       
                       {'label':'Auto-Response', 'action':'manage_list_autoresp'},                       
                       {'label':'Gateways',      'action':'manage_list_gateways'},                       
                       )
    

    def __init__(self, name):
        ''' '''
        self.id = name
        self.__mlist = MailList(name, lock=0)
        self.__mlist.__allow_access_to_unprotected_subobjects__ = 1
        self.title = self.__mlist.description


    def __getattr__(self, name):
        ''' '''
        if name == 'members':
            return self.get_member_adaptor()
        
        if name != '__mlist' and name in self.__mlist.__dict__.keys():
            return getattr(self.__mlist, name)
        else:
            return Base.__getattr__(self, name)



    def __getitem__(self, name):
        ''' '''
        if name == 'members':
            return self.get_member_adaptor()

        if name in self.__mlist.__dict__.keys():
            return getattr(self.__mlist, name)
        else:
            return getattr(self, name)


    #def __setattr__(self, name, value):
    #    ''' '''
    #    print name, value
    #    if name == 'members':
    #        print 3
    #        return setattr(self.get_member_adaptor(), name, value)
    #    
    #    if name != '__mlist' and name in self.__mlist.__dict__.keys():
    #        print 2
    #        return setattr(self.__mlist, name, value)
    #    else:
    #        print 1
    #        return Base.__setattr__(self, name, value)
    #    print 4
    #
    
    def __setitem__(self, name, value):
        ''' '''
        if name == 'members':
            return setattr(self.get_member_adaptor(), name, value)
    
        if name in self.__mlist.__dict__.keys():
            return setattr(self.__mlist, name, value)
        else:
            return setattr(self, name, value)


    def __bobo_traverse__(self, REQUEST, name=None):
        ''' '''
        if name == 'members':
            return self.get_member_adaptor()
        elif name in self.__mlist.__dict__.keys():
            return getattr(self.__mlist, name)
        else:
            return getattr(self, name)


    def bobobase_modification_time(self):
        ''' '''
        # returns creation time; oh well, better than nothing 
        return DateTime.DateTime(self.__mlist.created_at)


    def get_list(self):
        ''' '''
        return self.__mlist
        

    def get_member_adaptor(self):
        ''' '''
        adaptor = self.__mlist._memberadaptor
        adaptor.__allow_access_to_unprotected_subobjects__ = 1
        return adaptor
        
        
    def get_size(self):
        ''' '''
        # It really returns the number of members :)
        return len(self.get_member_adaptor().getMembers())




