from Mailman import mm_cfg 

from Products.Formulator import StandardFields
from Products.Formulator import Form

# General Options Fields

real_name = StandardFields.StringField(
    "real_name",
    title         = "The public name of this list (make case-changes only).",
    description   = ("The capitalization of this name can be changed to make it "
                     "presentable in polite company as a proper noun, or to make "
                     "an acronym part all upper case, etc. However, the name will "
                     "be advertised as the email address (e.g., in subscribe "
                     "confirmation notices), so it should not be otherwise "
                     "altered. (Email addresses are not case sensitive, but they "
                     "are sensitive to almost everything else :-)"), 
    required      = 1,
    display_width = 35,
    max_length    = 100)


owner = StandardFields.LinesField(
    "owner",
    title         = ("The list administrator email addresses. Multiple administrator "
                     "addresses, each on separate line is okay."),
    description   = ("There are two ownership roles associated with each mailing list. "
                     "The list administrators are the people who have ultimate control "
                     "over all parameters of this mailing list. They are able to "
                     "change any list configuration variable available through these "
                     "administration web pages. " 
                     "\n"
                     "The list moderators have more limited permissions; they are not "
                     "able to change any list configuration variable, but they are "
                     "allowed to tend to pending administration requests, including "
                     "approving or rejecting held subscription requests, and disposing "
                     "of held postings. Of course, the list administrators can also "
                     "tend to pending requests." 
                     "\n"
                     "In order to split the list ownership duties into administrators "
                     "and moderators, you must set a separate moderator password, and "
                     "also provide the email addresses of the list moderators. Note "
                     "that the field you are changing here specifies the list "
                     "administators."),
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 1000)


moderator = StandardFields.LinesField(
    "moderator",
    title         = ("The list moderator email addresses. Multiple moderator "
                     "addresses, each on separate line is okay."),
    description   = ("There are two ownership roles associated with each mailing list. "
                     "The list administrators are the people who have ultimate control "
                     "over all parameters of this mailing list. They are able to "
                     "change any list configuration variable available through these "
                     "administration web pages." 
                     "\n"
                     "The list moderators have more limited permissions; they are not "
                     "able to change any list configuration variable, but they are "
                     "allowed to tend to pending administration requests, including "
                     "approving or rejecting held subscription requests, and disposing "
                     "of held postings. Of course, the list administrators can also "
                     "tend to pending requests." 
                     "\n"
                     "In order to split the list ownership duties into administrators "
                     "and moderators, you must set a separate moderator password, and "
                     "also provide the email addresses of the list moderators in this "
                     "section. Note that the field you are changing here specifies "
                     "the list moderators."),
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 1000)


description = StandardFields.StringField(
    "description",
    title         = "A terse phrase identifying this list.",
    description   = ("This description is used when the mailing list is listed with "
                     "other mailing lists, or in headers, and so forth. It should be as "
                     "succinct as you can get it, while still identifying what the list "
                     "is."), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


info = StandardFields.TextAreaField(
    "info",
    title         = ("An introductory description - a few paragraphs - about "
                     "the list. It will be included, as html, at the top of "
                     "the listinfo page. Carriage returns will end a paragraph "
                     "- see the details for more info"),
    description   = ("The text will be treated as html except that newlines will be "
                     "translated to <br> - so you can use links, preformatted text, "
                     "etc, but don't put in carriage returns except where you mean "
                     "to separate paragraphs. And review your changes - bad html "
                     "(like some unterminated HTML constructs) can prevent display of "
                     "the entire listinfo page."), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 1000)


subject_prefix = StandardFields.StringField(
    "subject_prefix",
    title         = "Prefix for subject line of list postings.",
    description   = ("This text will be prepended to subject lines of messages posted "
                     "to the list, to distinguish mailing list messages in in mailbox "
                     "summaries. Brevity is premium here, it's ok to shorten long "
                     "mailing list names to something more concise, as long as it "
                     "still identifies the mailing list."), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


first_strip_reply_to = StandardFields.RadioField(
    "first_strip_reply_to",
    title         = ("Before adding a list-specific Reply-To: header, should any existing "
                     "Reply-To: field be stripped from the message?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Yes',   1), ('No',  0)])


reply_goes_to_list = StandardFields.RadioField(
    "reply_goes_to_list",
    title         = ("Where are replies to list messages directed? Poster is strongly "
                     "recommended for most mailing lists."),
    description   = ("This option controls what Mailman does to the Reply-To: header in "
                     "messages flowing through this mailing list. When set to Poster, no "
                     "Reply-To: header is added by Mailman, although if one is present in "
                     "the original message, it is not stripped. Setting this value to "
                     "either This list or Explicit address causes Mailman to insert a "
                     "specific Reply-To: header in all messages, overriding the header in "
                     "the original message if necessary (Explicit address inserts the "
                     "value of reply_to_address)."
                     "\n"
                     "There are many reasons not to introduce or override the Reply-To: "
                     "header. One is that some posters depend on their own Reply-To: "
                     "settings to convey their valid return address. Another is that "
                     "modifying Reply-To: makes it much more difficult to send private "
                     "replies. See `Reply-To' Munging Considered Harmful for a general "
                     "discussion of this issue. See Reply-To Munging Considered Useful "
                     "for a dissenting opinion." 
                     "\n"
                     "Some mailing lists have restricted posting privileges, with a "
                     "parallel list devoted to discussions. Examples are 'patches' or "
                     "'checkin' lists, where software changes are posted by a revision "
                     "control system, but discussion about the changes occurs on a "
                     "developers mailing list. To support these types of mailing lists, "
                     "select Explicit address and set the Reply-To:"), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Poster',   1), ('This list',  2), ('Explicit address', 3)])


reply_to_address = StandardFields.StringField(
    "reply_to_address",
    title         = "Explicit Reply-To: header.",
    description   = ("This is the address set in the Reply-To: header when the "
                     "reply_goes_to_list option is set to Explicit address."
                     "\n"
                     "There are many reasons not to introduce or override the Reply-To: "
                     "header. One is that some posters depend on their own Reply-To: "
                     "settings to convey their valid return address. Another is that "
                     "modifying Reply-To: makes it much more difficult to send private "
                     "replies. See `Reply-To' Munging Considered Harmful for a general "
                     "discussion of this issue. See Reply-To Munging Considered Useful "
                     "for a dissenting opinion." 
                     "\n"
                     "Some mailing lists have restricted posting privileges, with a "
                     "parallel list devoted to discussions. Examples are 'patches' or "
                     "'checkin' lists, where software changes are posted by a revision "
                     "control system, but discussion about the changes occurs on a "
                     "developers mailing list. To support these types of mailing lists, "
                     "specify the explicit Reply-To: address here. You must also specify "
                     "Explicit address in the reply_goes_to_list variable." 
                     "\n"
                     "Note that if the original message contains a Reply-To: header, it "
                     "will not be changed."), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


umbrella_list = StandardFields.RadioField(
    "umbrella_list",
    title         = ("Send password reminders to, eg, '-owner' address instead of "
                     "directly to user."),
    description   = ("Set this to yes when this list is intended to cascade only to other "
                     "mailing lists. When set, meta notices like confirmations and "
                     "password reminders will be directed to an address derived from "
                     "the member's address - it will have the value of "
                     "'umbrella_member_suffix' appended to the member's account name."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


umbrella_member_suffix = StandardFields.StringField(
    "umbrella_member_suffix",
    title         = ("Suffix for use when this list is an umbrella for other lists, "
                     "according to setting of previous 'umbrella_list' setting."),
    description   = ("When 'umbrella_list' is set to indicate that this list has other "
                     "mailing lists as members, then administrative notices like "
                     "confirmations and password reminders need to not be sent to the "
                     "member list addresses, but rather to the owner of those member "
                     "lists. In that case, the value of this setting is appended to the "
                     "member's account name for such notices. '-owner' is the typical "
                     "choice. This setting has no effect when 'umbrella_list' is 'No'."), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


send_reminders = StandardFields.RadioField(
    "send_reminders",
    title         = ("Send monthly password reminders?"),
    description   = ("Turn this on if you want password reminders to be sent once per "
                     "month to your members. Note that members may disable their own "
                     "individual password reminders."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)]) 


welcome_msg = StandardFields.TextAreaField(
    "welcome_msg",
    title         = ("List-specific text prepended to new-subscriber welcome message."),
    description   = ("This value, if any, will be added to the front of the "
                     "new-subscriber welcome message. The rest of the welcome message "
                     "already describes the important addresses and URLs for the "
                     "mailing list, so you don't need to include any of that kind of "
                     "stuff here. This should just contain mission-specific kinds of "
                     "things, like etiquette policies or team orientation, or that "
                     "kind of thing." 
                     "\n"
                     "Note that this text will be wrapped, according to the following "
                     "rules:" 
                     "\n"
                     "  - Each paragraph is filled so that no line is longer than 70 characters." 
                     "  - Any line that begins with whitespace is not filled." 
                     "  = A blank line separates paragraphs."), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 1000)


send_welcome_msg = StandardFields.RadioField(
    "send_welcome_msg",
    title         = ("Send welcome message to newly subscribed members?"),
    description   = ("Turn this off only if you plan on subscribing people manually and "
                     "don't want them to know that you did so. This option is most useful "
                     "for transparently migrating lists from some other mailing list "
                     "manager to Mailman."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)]) 


goodbye_msg = StandardFields.TextAreaField(
    "goodbye_msg",
    title         = ("Text sent to people leaving the list. If empty, no special text will "
                     "be added to the unsubscribe message."),
    description   = (""), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 1000)


send_goodbye_msg = StandardFields.RadioField(
    "send_goodbye_msg",
    title         = ("Send goodbye message to members when they are unsubscribed?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)]) 


admin_immed_notify = StandardFields.RadioField(
    "admin_immed_notify",
    title         = ("Should the list moderators get immediate notice of new requests, as "
                     "well as daily notices about collected ones?"),
    description   = ("List moderators (and list administrators) are sent daily reminders "
                     "of requests pending approval, like subscriptions to a moderated list, "
                     "or postings that are being held for one reason or another. Setting "
                     "this option causes notices to be sent immediately on the arrival of "
                     "new requests as well."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)]) 


admin_notify_mchanges = StandardFields.RadioField(
    "admin_notify_mchanges",
    title         = ("Should administrator get notices of subscribes and unsubscribes?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


respond_to_post_requests = StandardFields.RadioField(
    "respond_to_post_requests",
    title         = ("Send mail to poster when their posting is held for approval?"),
    description   = ("Approval notices are sent when mail triggers certain of the limits "
                     "except routine list moderation and spam filters, for which notices "
                     "are not sent. This option overrides ever sending the notice."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


administrivia = StandardFields.RadioField(
    "administrivia",
    title         = ("(Administrivia filter) Check postings and intercept ones that seem to "
                     "be administrative requests?"),
    description   = ("Administrivia tests will check postings to see whether it's really meant "
                     "as an administrative request (like subscribe, unsubscribe, etc), and "
                     "will add it to the the administrative requests queue, notifying the "
                     "administrator of the new request, in the process."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


max_message_size = StandardFields.IntegerField(
    "max_message_size",
    title         = ("Maximum length in kilobytes (KB) of a message body. Use 0 for no limit."),
    description   = (""),
    default       = 35,
    required      =  1,
    display_width =  5)


host_name = StandardFields.StringField(
    "host_name",
    title         = "Host name this list prefers for email.",
    description   = ("The 'host_name' is the preferred name for email to mailman-related "
                     "addresses on this host, and generally should be the mail host's "
                     "exchanger address, if any. This setting can be useful for selecting "
                     "among alternative names of a host that has multiple addresses."), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


admin_passwd = StandardFields.PasswordField(
    "admin_passwd",
    title         = "Enter new administrator password",
    description   = (""), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


admin_passwd_confirm = StandardFields.PasswordField(
    "admin_passwd_confirm",
    title         = "Confirm administator password",
    description   = (""), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


moderator_passwd = StandardFields.PasswordField(
    "moderator_passwd",
    title         = "Enter new moderator password:",
    description   = (""), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


moderator_passwd_confirm = StandardFields.PasswordField(
    "moderator_passwd_confirm",
    title         = "Confirm moderator password",
    description   = (""), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


def items(self):
    ''' '''
    langs = []
    for lang in self.available_languages:
        lang.append((mm_cfg.LC_DESCRIPTIONS[lang][0], lang))
    return langs


preferred_language = StandardFields.ListField(
    "preferred_language",
    title         = "Default language for this list.",
    description   = ("This is the default natural language for this mailing list. If more "
                     "than one language is supported then users will be able to select "
                     "their own preferences for when they interact with the list. All "
                     "other interactions will be conducted in the default language. This "
                     "applies to both web-based and email-based messages, but not to "
                     "email posted by list members."), 
    required      = 1,
    size          = 1)

from Products.Formulator.TALESField import TALESMethod
preferred_language.tales['items'] = TALESMethod("python: form.get_available_languages_info()")


all_languages = map(lambda x, lc=mm_cfg.LC_DESCRIPTIONS: (lc[x][0], x),
                        mm_cfg.LC_DESCRIPTIONS.keys())
all_languages.sort()

available_languages = StandardFields.MultiListField(
    "available_languages",
    title         = "Languages supported by this list.",
    description   = ("These are all the natural languages supported by this list. Note "
                     "that the default language must be included."), 
    required      = 1,
    size          = 5,
    items         = all_languages)

del all_languages


notify_member = StandardFields.RadioField(
    "notify_member",
    title         = "Notify the member about the subscription/removal.",
    description   = (""), 
    required      = 0,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


notify_owner = StandardFields.RadioField(
    "notify_owner",
    title         = "Notify the owner about the subscription/removal.",
    description   = (""), 
    required      = 0,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


address_list = StandardFields.LinesField(
    "address_list",
    title         = ("List E-mail addresses for subscription/removal."),
    description   = ("Please enter one address per line."),
    required      =  0,
    width         = 35,
    height        = 10,
    max_length    = 1000)


nondigestable = StandardFields.RadioField(
    "nondigestable",
    title         = "Can subscribers choose to receive mail immediately, rather than in batched digests?",
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


msg_header = StandardFields.TextAreaField(
    "msg_header",
    title         = ("Header added to mail sent to regular list members"),
    description   = ("Text prepended to the top of every immediately-delivery message. This "
                     " text can include %(attribute)s format strings which are resolved "
                     "against the list's attributes. For details, see Python's string "
                     "formatting rules. Some useful attributes are: "
                     "\n"
                     "real_name - The `pretty' name of the list; usually the list name with "
                     "capitalization." 
                     "_internal_name - The name by which the list is identified in URLs, "
                     "where case is significant." 
                     "host_name - The fully qualified domain name that the list server runs on." 
                     "web_page_url - The base URL for Mailman. This can be appended with, e.g. "
                     "listinfo/%(_internal_name)s to yield the listinfo page for the mailing "
                     "list." 
                     "description - The brief description of the mailing list." 
                     "info - The full description of the mailing list. "), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


msg_footer = StandardFields.TextAreaField(
    "msg_footer",
    title         = ("Footer added to mail sent to regular list members"),
    description   = ("Text prepended to the top of every immediately-delivery message. This "
                     " text can include %(attribute)s format strings which are resolved "
                     "against the list's attributes. For details, see Python's string "
                     "formatting rules. Some useful attributes are: "
                     "\n"
                     "real_name - The `pretty' name of the list; usually the list name with "
                     "capitalization." 
                     "_internal_name - The name by which the list is identified in URLs, "
                     "where case is significant." 
                     "host_name - The fully qualified domain name that the list server runs on." 
                     "web_page_url - The base URL for Mailman. This can be appended with, e.g. "
                     "listinfo/%(_internal_name)s to yield the listinfo page for the mailing "
                     "list." 
                     "description - The brief description of the mailing list." 
                     "info - The full description of the mailing list. "), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


digestable = StandardFields.RadioField(
    "digestable",
    title         = "Can list members choose to receive list traffic bunched in digests?",
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


digest_is_default = StandardFields.RadioField(
    "digest_is_default",
    title         = "Which delivery mode is the default for new users?",
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Regular',   0), ('Digest',  1)])


mime_is_default_digest = StandardFields.RadioField(
    "mime_is_default_digest",
    title         = "When receiving digests, which format is default?",
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Plain',   0), ('MIME',  1)])


digest_size_threshhold = StandardFields.IntegerField(
    "digest_size_threshhold",
    title         = ("How big in Kb should a digest be before it gets sent out?"),
    description   = (""),
    required      =  1,
    display_width =  5)


digest_send_periodic = StandardFields.RadioField(
    "digest_send_periodic",
    title         = "Should a digest be dispatched daily when the size threshold isn't reached?",
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


digest_header = StandardFields.TextAreaField(
    "digest_header",
    title         = ("Header added to every digest"),
    description   = ("Text attached (as an initial message, before the table of contents) "
                     "to the top of digests. This text can include %(attribute)s format "
                     "strings which are resolved against the list's attributes. For "
                     "details, see Python's string formatting rules. Some useful attributes "
                     "are:"
                     "\n"
                     "real_name - The `pretty' name of the list; usually the list name with"
                     "capitalization." 
                     "_internal_name - The name by which the list is identified in URLs, "
                     "where case is significant." 
                     "host_name - The fully qualified domain name that the list server runs "
                     "on." 
                     "web_page_url - The base URL for Mailman. This can be appended with, "
                     "e.g. listinfo/%(_internal_name)s to yield the listinfo page for the "
                     "mailing list." 
                     "description - The brief description of the mailing list. "
                     "info - The full description of the mailing list."), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


digest_footer = StandardFields.TextAreaField(
    "digest_footer",
    title         = ("Footer added to every digest"),
    description   = ("Text attached (as an initial message, before the table of contents) "
                     "to the top of digests. This text can include %(attribute)s format "
                     "strings which are resolved against the list's attributes. For "
                     "details, see Python's string formatting rules. Some useful attributes "
                     "are:"
                     "\n"
                     "real_name - The `pretty' name of the list; usually the list name with"
                     "capitalization." 
                     "_internal_name - The name by which the list is identified in URLs, "
                     "where case is significant." 
                     "host_name - The fully qualified domain name that the list server runs "
                     "on." 
                     "web_page_url - The base URL for Mailman. This can be appended with, "
                     "e.g. listinfo/%(_internal_name)s to yield the listinfo page for the "
                     "mailing list." 
                     "description - The brief description of the mailing list. "
                     "info - The full description of the mailing list."), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


digest_volume_frequency = StandardFields.RadioField(
    "digest_volume_frequency",
    title         = ("How often should a new digest volume be started?"),
    description   = ("When a new digest volume is started, the volume number is"
                     "incremented and the issue number is reset to 1."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Yearly',   0), ('Monthly',  1), ('Quarterly',  2), ('Weekly',  3),
                     ('Daily',  4)])


advertised = StandardFields.RadioField(
    "advertised",
    title         = "Advertise this list when people ask what lists are on this machine?",
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


subscribe_policy = StandardFields.RadioField(
    "subscribe_policy",
    title         = "What steps are required for subscription?",
    description   = ("Confirm (*) - email confirmation required "
                     "Require approval - require list administrator approval for subscriptions" 
                     "Confirm and approve - both confirm and approve "
                     "\n"
                     "(*) when someone requests a subscription, Mailman sends them a notice "
                     "with a unique subscription request number that they must reply to in "
                     "order to subscribe."
                     "This prevents mischievous (or malicious) people from creating subscriptions "
                     "for others without their consent."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Confirm',   1), ('Require Approval',  2), ('Confirm and approve', 3)])


unsubscribe_policy = StandardFields.RadioField(
    "unsubscribe_policy",
    title         = ("Is the list moderator's approval required for unsubscription requests? "
                     "(No is recommended)"),
    description   = ("When members want to leave a list, they will make an unsubscription "
                     "request, either via the web or via email. Normally it is best for you "
                     "to allow open unsubscriptions so that users can easily remove themselves "
                     "from mailing lists (they get really upset if they can't get off lists!). "
                     "\n"
                     "For some lists though, you may want to impose moderator approval before "
                     "an unsubscription request is processed. Examples of such lists include "
                     "a corporate mailing list that all employees are required to be members of."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


private_roster = StandardFields.RadioField(
    "private_roster",
    title         = ("Who can view subscription list?"),
    description   = ("When set, the list of subscribers is protected by member or admin "
                     "password authentication."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Anyone',   1), ('List Members',  2), ('List admin only', 3)])


obscure_addresses = StandardFields.RadioField(
    "obscure_addresses",
    title         = ("Show member addrs so they're not directly recognizable as email addrs?"),
    description   = ("Setting this option causes member email addresses to be transformed "
                     "when they are presented on list web pages (both in text and as links), "
                     "so they're not trivially recognizable as email addresses. The intention "
                     "is to prevent the addresses from being snarfed up by automated web "
                     "scanners for use by spammers."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


bounce_processing = StandardFields.RadioField(
    "bounce_processing",
    title         = ("Try to figure out error messages automatically?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


minimum_removal_date = StandardFields.IntegerField(
    "minimum_removal_date",
    title         = ("Minimum number of days an address has been non-fatally bad before "
                     "we take action"),
    description   = (""),
    default       = 35,
    required      =  1,
    display_width =  5)


minimum_post_count_before_bounce_action = StandardFields.IntegerField(
    "minimum_post_count_before_bounce_action",
    title         = ("Minimum number of posts to the list since members first bounce "
                     "before we consider removing them from the list"),
    description   = (""),
    default       = 35,
    required      =  1,
    display_width =  5)


max_posts_between_bounces = StandardFields.IntegerField(
    "max_posts_between_bounces",
    title         = ("Maximum number of messages your list gets in an hour. (Yes, "
                     "bounce detection finds this info useful)"),
    description   = (""),
    default       = 35,
    required      =  1,
    display_width =  5)


automatic_bounce_action = StandardFields.RadioField(
    "automatic_bounce_action",
    title         = ("Action when critical or excessive bounces are detected."),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Do nothing',   1), ('Disable and notify me',  2),
                     ('Disable and DON\'T notify me', 3), ('Remove and notify me', 4)])


archive = StandardFields.RadioField(
    "archive",
    title         = ("Archive messages?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


archive_private = StandardFields.RadioField(
    "archive_private",
    title         = ("Is archive file source for public or private archival?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('public',   1), ('private',  2)])


archive_volume_frequency = StandardFields.RadioField(
    "archive_volume_frequency",
    title         = ("How often should a new archive volume be started?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('Yearly',   0), ('Monthly',  1), ('Quarterly',  2), ('Weekly',  3), ('Daily',  4)])


autorespond_postings = StandardFields.RadioField(
    "autorespond_postings",
    title         = ("Should Mailman send an auto-response to mailing list posters?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


autoresponse_postings_text = StandardFields.TextAreaField(
    "autoresponse_postings_text",
    title         = ("Auto-response text to send to mailing list posters."),
    description   = (""), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


autorespond_admin = StandardFields.RadioField(
    "autorespond_admin",
    title         = ("Should Mailman send an auto-response to emails sent to the -admin "
                     "and -owner addresses?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


autoresponse_admin_text = StandardFields.TextAreaField(
    "autoresponse_admin_text",
    title         = ("Auto-response text to send to -admin and -owner emails."),
    description   = (""), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


autorespond_requests = StandardFields.RadioField(
    "autorespond_requests",
    title         = ("Should Mailman send an auto-response to emails sent to the "
                     "-request address? If you choose yes, decide whether you want "
                     "Mailman to discard the original email, or forward it on to the "
                     "system as a normal mail command."),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes, /w discart',  1), ('Yes, w/forward', 2)])


autoresponse_request_text = StandardFields.TextAreaField(
    "autoresponse_request_text",
    title         = ("Auto-response text to send to -request emails."),
    description   = (""), 
    required      =  0,
    width         = 35,
    height        =  3,
    max_length    = 3000)


autoresponse_graceperiod = StandardFields.IntegerField(
    "autoresponse_graceperiod",
    title         = ("Number of days between auto-responses to either the mailing "
                     "list or -admin/-owner address from the same poster. Set to "
                     "zero (or negative) for no grace period (i.e. auto-respond to "
                     "every message)."),
    description   = (""),
    default       = 35,
    required      =  1,
    display_width =  5)


nntp_host = StandardFields.StringField(
    "nntp_host",
    title         = "The Internet address of the machine your News server is running on.",
    description   = ("The News server is not part of Mailman proper. You have to already "
                     "have access to a NNTP server, and that NNTP server has to recognize "
                     "the machine this mailing list runs on as a machine capable of reading "
                     "and posting news."), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


linked_newsgroup = StandardFields.StringField(
    "linked_newsgroup",
    title         = "The name of the Usenet group to gateway to and/or from.",
    description   = (""), 
    required      =  0,
    display_width = 35,
    max_length    = 100)


gateway_to_news = StandardFields.RadioField(
    "gateway_to_news",
    title         = ("Should new posts to the mailing list be sent to the newsgroup?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


gateway_to_mail = StandardFields.RadioField(
    "gateway_to_mail",
    title         = ("Should new posts to the newsgroup be sent to the mailing list?"),
    description   = (""), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])


_mass_catchup = StandardFields.RadioField(
    "_mass_catchup",
    title         = ("Should Mailman perform a catchup on the newsgroup?"),
    description   = ("When you tell Mailman to perform a catchup on the newsgroup, this "
                     "means that you want to start gating messages to the mailing list "
                     "with the next new message found. All earlier messages on the newsgroup "
                     "will be ignored. This is as if you were reading the newsgroup yourself, "
                     "and you marked all current messages as read. By catching up, your mailing "
                     "list members will not see any of the earlier messages."), 
    required      = 1,
    first_item    = 1,
    orientation   = 'horizontal',
    items         = [('No',   0), ('Yes',  1)])



# *** Management Forms *** 

general_form = Form.ZMIForm('general_form', 'General Options Form')
general_form.name = 'general_form'
general_form.action = 'manage_list_general_action'
general_form.method = 'POST'
general_form.enctype = 'application/x-www-form-urlencoded'

for field in (real_name, owner, moderator, description, info, subject_prefix, first_strip_reply_to,
              reply_goes_to_list, reply_to_address, umbrella_list, umbrella_member_suffix,
              send_reminders, welcome_msg, send_welcome_msg, goodbye_msg, send_goodbye_msg,
              admin_immed_notify, admin_notify_mchanges, respond_to_post_requests, administrivia,
              max_message_size, host_name):

    general_form._setObject(field.id, field)


passwords_form = Form.ZMIForm('passwords_form', 'Passwords Options Form')
passwords_form.name = 'passwords_form'
passwords_form.action = 'manage_list_passwords_action'
passwords_form.method = 'POST'
passwords_form.enctype = 'application/x-www-form-urlencoded'

for field in (admin_passwd, admin_passwd_confirm, moderator_passwd,
              moderator_passwd_confirm):
    passwords_form._setObject(field.id, field)


languages_form = Form.ZMIForm('languages_form', 'Languages Options Form')
languages_form.name = 'languages_form'
languages_form.action = 'manage_list_languages_action'
languages_form.method = 'POST'
languages_form.enctype = 'application/x-www-form-urlencoded'

for field in (preferred_language, available_languages):
    languages_form._setObject(field.id, field)


members_form = Form.ZMIForm('members_form', 'Members Options Form')
members_form.name = 'members_form'
members_form.action = 'manage_list_members_subscription'
members_form.method = 'POST'
members_form.enctype = 'application/x-www-form-urlencoded'

for field in (notify_member, notify_owner, address_list):
    members_form._setObject(field.id, field)


nondigest_form = Form.ZMIForm('nondigest_form', 'Non-Digest Options Form')
nondigest_form.name = 'nondigest_form'
nondigest_form.action = 'manage_list_nondigest_action'
nondigest_form.method = 'POST'
nondigest_form.enctype = 'application/x-www-form-urlencoded'

for field in (nondigestable, msg_header, msg_footer):
    nondigest_form._setObject(field.id, field)


digest_form = Form.ZMIForm('digest_form', 'Digest Options Form')
digest_form.name = 'digest_form'
digest_form.action = 'manage_list_digest_action'
digest_form.method = 'POST'
digest_form.enctype = 'application/x-www-form-urlencoded'

for field in (digestable, digest_is_default, mime_is_default_digest, digest_size_threshhold,
              digest_send_periodic, digest_header, digest_footer, digest_volume_frequency):
    digest_form._setObject(field.id, field)


privacy_form = Form.ZMIForm('privacy_form', 'Privacy Options Form')
privacy_form.name = 'privacy_form'
privacy_form.action = 'manage_list_privacy_action'
privacy_form.method = 'POST'
privacy_form.enctype = 'application/x-www-form-urlencoded'

for field in (advertised, subscribe_policy, unsubscribe_policy, private_roster,
              obscure_addresses):
    privacy_form._setObject(field.id, field)


bounce_form = Form.ZMIForm('bounce_form', 'Bounce Options Form')
bounce_form.name = 'bounce_form'
bounce_form.action = 'manage_list_bounce_action'
bounce_form.method = 'POST'
bounce_form.enctype = 'application/x-www-form-urlencoded'

for field in (bounce_processing, minimum_removal_date,
              minimum_post_count_before_bounce_action,
              max_posts_between_bounces, automatic_bounce_action):
    bounce_form._setObject(field.id, field)


archive_form = Form.ZMIForm('archive_form', 'Archive Options Form')
archive_form.name = 'archive_form'
archive_form.action = 'manage_list_archive_action'
archive_form.method = 'POST'
archive_form.enctype = 'application/x-www-form-urlencoded'

for field in (archive, archive_private, archive_volume_frequency):
    archive_form._setObject(field.id, field)


autoresp_form = Form.ZMIForm('autoresp_form', 'Autoresp Options Form')
autoresp_form.name = 'autoresp_form'
autoresp_form.action = 'manage_list_autoresp_action'
autoresp_form.method = 'POST'
autoresp_form.enctype = 'application/x-www-form-urlencoded'

for field in (autorespond_postings, autoresponse_postings_text, autorespond_admin,
              autoresponse_admin_text, autorespond_requests, autoresponse_request_text,
              autoresponse_graceperiod):
    autoresp_form._setObject(field.id, field)


gateways_form = Form.ZMIForm('gateways_form', 'Gateways Options Form')
gateways_form.name = 'gateways_form'
gateways_form.action = 'manage_list_gateways_action'
gateways_form.method = 'POST'
gateways_form.enctype = 'application/x-www-form-urlencoded'

for field in (nntp_host, linked_newsgroup, gateway_to_news, gateway_to_mail):
    gateways_form._setObject(field.id, field)
