MAILMAN_PREFIX_DIR = '/opt/Mailman2.1'

import sys
sys.path.append(MAILMAN_PREFIX_DIR)


from Products.ZMailman import MailmanFolder


def initialize(context):


    import ZMailList, ZMMUserFolder

    context.registerClass(
        MailmanFolder.MailmanFolder, 
        constructors=(MailmanFolder.manage_addMailmanFolderForm,
                      MailmanFolder.manage_addMailmanFolder),
        icon="www/icon.gif"
        )

    context.registerClass(
        ZMailList.ZMailList, 
        constructors=(ZMailList.manage_addMailListForm,
                      ZMailList.manage_addMailList),
        icon="www/MailList.gif",
        visibility=None
        )

    from Products.ZMailman import ZMailListFields
    for name in ('general_form', 'passwords_form', 'languages_form', 'members_form', 'nondigest_form',
                 'digest_form', 'privacy_form', 'bounce_form', 'archive_form',
                 'autoresp_form', 'gateways_form'):
        form = ZMailListFields.__dict__[name]
        setattr(ZMailList.ZMailList, name, form)


    # A Mailman-specific User Folder
        
    context.registerClass(
        ZMMUserFolder.ZMMUserFolder, 
        constructors=(ZMMUserFolder.manage_addZMMUserFolderForm,
                      ZMMUserFolder.manage_addZMMUserFolder),
        )



# load all the icons automatically
from Globals import package_home, ImageFile
import os
misc_ = {}
path = os.path.join(package_home(globals()), 'www/')

for file in os.listdir(path):
    if file[-3:] in ['gif', 'jpg', 'png']:
        misc_[file[:-4]] = ImageFile('www/%s' %file, globals())
