
# 
# LocalProc Product
# 
# Steve Spicklemire
# Silicon Prairie Ventures Inc. (SPVI)
# 
# Disclaimer
#   
#   THIS SOFTWARE IS PROVIDED BY SPVI ``AS IS'' AND ANY EXPRESSED OR
#   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#   DISCLAIMED.  IN NO EVENT SHALL SPVI OR ITS CONTRIBUTORS BE LIABLE FOR
#   ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
#   GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
#   IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
#   OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
#   ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#   
# 
# 

__doc__ = "LocalProc Product"
__version__ = "0.0.1"

from ShellCommandProcessor import ShellCommandProcessor
import os
import string

import Globals, OFS, AccessControl, zLOG
from Acquisition import Implicit
from Globals import Persistent, HTMLFile, MessageDialog

class LocalProc(Persistent,
                Implicit,
                AccessControl.Role.RoleManager,
                OFS.SimpleItem.Item,
                ShellCommandProcessor):

    """LocalProc"""

    meta_type = "LocalProc"
    title=''
    command = ''
    fsdir = ''
    fsdirsFName = 'localProc_allowedFSDirs.txt'
    commandsFName = 'localProc_allowedCommands.txt'

    __ac_permissions__ = (

        ('Manage Local Proc',
         ['manage_editLocalProc', 'manage_editLocalProcForm'], ['Manager']),
        
        ('Execute LocalProc',
         ['manage_performLocalProc'],['Manager']),

	)

    manage_options = (
	{'label':'LocalProc Controls', 'action':'manage_editLocalProcForm'},
        {'label':'Test', 'action':'manage_performLocalProc'},
        {'label':'Environ', 'action':'manage_editEnviron'},
	)

    manage_editLocalProcForm = HTMLFile('editLocalProc', globals())
    manage_editEnviron = HTMLFile('editEnviron', globals())
    
    def manage_editLocalProc(self, title, command, fsdir, commandsFName, fsdirsFName, active=0, background=0):
        """ update fsdir and command.. """

        self.title = title
        self.fsdir=self.manage_getDirs()[fsdir]
        self.command=self.manage_getCommands()[command]
        self.active = active
        self.background = background
        self.commandsFName = commandsFName
        self.fsdirsFName = fsdirsFName

        return MessageDialog(title='OK',
			     message='Local Proc Params Edited.',
			     action='manage_editLocalProcForm')


    def manage_checkBackgroundProcess(self):
        """ check for output file from background process.... """

        if hasattr(self, 'backOut'):
            if os.path.isfile(self.backOut):
                return self.getBackgroundResults()

        self.backOut = None
        self.backErr = None
        return "Nope... "
                
    def manage_performLocalProc(self):
        """ do the proc! """

        if hasattr(self, 'backOut') and self.backOut:
            return MessageDialog(title="Check Background Process",
                                 message="Sorry.. background process could still be running... ",
                                 action="manage_checkBackgroundProcess")
        else:
            oldwd = os.getcwd()

            for p in self.propertysheets.get('Environ').propertyIds():
                os.environ[p] = self.propertysheets.get('Environ').getProperty(p)
                
            os.chdir( self.fsdir )
            result = self.processCommand( self.command )
            os.chdir( oldwd)

            return result

    def manage_getCommands(self):
        """ get the allowed commands.. """

        try:
            f = open(os.path.join(os.path.join(Globals.data_dir, 'localProc') , self.commandsFName))
            result = f.readlines()
            f.close()
        except:
            result = ['No File Found... ']

        return map(string.strip, result)

    def manage_getDirs(self):
        """ get the allowed dirs.. """
        try:
            f = open(os.path.join(os.path.join(Globals.data_dir, 'localProc'),self.fsdirsFName))
            result = f.readlines()
            f.close()
        except:
            result = ['No File Found... ']
        return map(string.strip, result)
        
manage_addLocalProcForm = HTMLFile('addLocalProc', globals())

def manage_addLocalProc(self, id, title=''):
    '''Adds a LocalProc Object to the current folder.
    '''

    ob = LocalProc()
    ob.id = id
    ob.title = title
    ob.propertysheets = OFS.PropertySheets.PropertySheets()
    ob.propertysheets.manage_addPropertySheet(id="Environ",ns=None)

    self._setObject(id, ob)

    if not os.path.isdir(os.path.join(Globals.data_dir, 'localProc')):
        os.mkdir(os.path.join(Globals.data_dir, 'localProc'))
        
    return MessageDialog(title='OK',
                         message = ' Added LocalProc object. ',
                         action='manage_main')


Globals.default__class_init__(LocalProc)

