
import os
import tempfile
import string

try:
    import zLOG

except:
    class foo:
        pass

    def LOG( subsystem, severity, short ):
        if severity > -500:
            print subsystem, severity, short

    zLOG = foo()
    zLOG.LOG = LOG
    zLOG.BLATHER = 0
    zLOG.INFO = 1

class ShellCommandProcessor:

    active = 0
    background = 0
    _v_debug = 0
    backOut = None
    backErr = None

    def getBackgroundResults(self):

        if self.backOut and os.path.isfile(self.backOut):
            resultStd = open(self.backOut).read()

        else:
            resultStd = ""

        if self.backErr and os.path.isfile(self.backErr):
            resultErr = open(self.backErr).read()
        else:
            resultErr = ""

        if resultStd or resultErr:
            if self.backOut:
                if os.path.isfile(self.backOut):
                    os.remove(self.backOut)
                self.backOut = None

            if self.backErr:
                if os.path.isfile(self.backErr):
                    os.remove(self.backErr)
                self.backErr = None

        else:
            resltStd = "No output yet.. "

        return self.formatResult( 'background command..', 0, resultStd, resultErr)
        
    def processStreams(self, command ):

        if not self.active:
            if self._v_debug:
                zLOG.LOG('LocalProc', zLOG.BLATHER,
                         "Not processing streams... self.active = 0")
                
            return  0, '', '' # no commands are executed unless this is true....
        
        #
        # Zope doesn't like forking... so let's just be dumb and use files
        # rather than pipes..
        #
        
        stdoutFname = tempfile.mktemp()
        stderrFname = tempfile.mktemp()

        iresult = self.doCommand( command, stdoutFname, stderrFname )

        if self.background:
            self.backOut = stdoutFname
            self.backErr = stderrFname

            return iresult, '-- background process --', '-- background process --'

        else:

            zLOG.LOG('LocalProc', zLOG.BLATHER, 'checking result .. "%i"' % iresult)

            resultStd = open(stdoutFname).read()
            resultErr = open(stderrFname).read()

            os.remove(stdoutFname)
            os.remove(stderrFname)

            zLOG.LOG('LocalProc', zLOG.BLATHER, 'Got result.. "%s"' % resultStd)
            zLOG.LOG('LocalProc', zLOG.BLATHER, 'Got err result.. "%s"' % resultErr)

            return iresult, resultStd, resultErr

    def doCommandUnix(self, command, stdoutFname, stderrFname):

        cmd = 'sh -v -c "%s" >%s 2>%s' % (command, stdoutFname, stderrFname)

        if self.background:
            cmd = cmd + ' &'
            
        iresult = os.system(cmd)
        return iresult

    def doCommandWin(self, command, stdoutFname, stderrFname):
        """ this doesn't work at all.... any takers? """
        
        return 0

    def processCommand( self, command):
        """
        Run a cvs command as a pipe..
        """

        resultVal, resultStd, resultErr = self.processStreams( command )

        return self.formatResult( command, resultVal, resultStd, resultErr)

    def formatResult(self, command, resultVal, resultStd, resultErr):
        """ format the results of a command.... """
        
        result = ["Command: '%s' returns %i" % (srj(command), resultVal)]
        result.append("StdOut: '%s'" % resultStd)
        result.append("StdErr: '%s'" % resultErr)

        return string.join(result,'\n')

def splitResizeJoin( aString, maxSize = 70 ):

    words = string.split(aString)
    newLines = []
    currString = ''

    for word in words:
        if len(word) + len(currString) > maxSize:
            newLines.append(currString)
            currString = ''
        currString = currString + ' ' + word
    if currString:
        newLines.append(currString)

    return string.join(newLines,'\n')

srj = splitResizeJoin

try:
    import posix
    ShellCommandProcessor.doCommand = ShellCommandProcessor.doCommandUnix
except:
    ShellCommandProcessor.doCommand = ShellCommandProcessor.doCommandWin

if __name__=='__main__':
    x = ShellCommandProcessor()
    x.active = 1

    print x.processStreams('ls -lga')
