import os
import sys
import unittest

SOFTWARE_HOME = os.getenv("SOFTWARE_HOME", os.path.dirname(sys.executable))

ZOPE_HOME=os.path.normpath(SOFTWARE_HOME + "/../lib/python")
sys.path.append(ZOPE_HOME)
from DocumentTemplate import HTML

# append path to calendar
PRODUCT_PATH = os.path.abspath(os.getcwd() + "/..")
sys.path.append(PRODUCT_PATH)

import DateTime
import CalendarTag

output = open("testCalendar.html", "w")

class CalendarTestCase(unittest.TestCase):

    def __init__(self, methodName="runTest"):
        unittest.TestCase.__init__(self, methodName)
        self.d = {"BASE1": "test",
            "QUERY_STRING": "",
            "URL": "./testTag",
            "startdate": DateTime.DateTime("2001-05-01"),
            }
        
    def testCellAttrs(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate>

                <dtml-with date>
                    <dtml-if "day()==15">
                        <dtml-call "setCalendar('cellattrs', (('style','background:#ff0000;color:#ffffff;'),))">
                    </dtml-if>                        
                </dtml-with>                    

                <dtml-var date fmt="%d">

            </dtml-calendar>
            """)
        result = template(**self.d)
        self.outputResults("testCellAttrs", "Red background, white text on fifteenth", result) 

    def testCellBackground(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate>

                <dtml-with date>
                    <dtml-if "day()==15">
                        <dtml-call "setCalendar('cellbgcolor', '#ff0000')">
                    <dtml-else>                        
                        <dtml-call "setCalendar('cellbgcolor', '#ffffff')">
                    </dtml-if>                        
                </dtml-with>                    

                <dtml-var date fmt="%d">

            </dtml-calendar>
            """)
        result = template(**self.d)
        self.outputResults("testCellBackground", "Red background on fifteenth", result) 

    def testBorder(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate>

                <dtml-call "setCalendar('spacing', 2)">
                <dtml-call "setCalendar('bordercolor', '#ff0000')">
                <dtml-var date fmt="%d">

            </dtml-calendar>
            """)
        result = template(**self.d)
        self.outputResults("testBorder", "Red border", result) 
        
    def testBackgroundColour(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate bgcolor=#ff0000>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testBackgroundColour", "Red background", result) 
        
    def testTableWidth(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate tablewidth=100%>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testTableWidth", "Calendar set to 100% width", result) 
        
    def testNoImages(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate images=no>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testNoImages", "Should not display images in the toolbar", result) 
        
    def testLimitWeekDays(self):
        template = HTML("""\
            <dtml-calendar mode=month date=startdate weekdays=15>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testLimitWeekDays", "Must display monday to fridays", result) 

    def testLanguage(self):
        
        template = HTML("""\
            <dtml-calendar mode=month date=startdate lang=zh_TW>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testLanguage", "Must display in chinese (set Encoding=Chinese in Internet Explorer)", result) 
        
    def testMonth(self):
        
        template = HTML("""\
            <dtml-calendar mode=month date=startdate>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testMonth", "Must display month-view", result) 
        
    def testModes(self):
        
        template = HTML("""\
            <dtml-calendar mode=month modes=week,month date=startdate>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testModes", "Must display only week and month modes", result) 
        
    def testDay(self):
        
        template = HTML("""\
            <dtml-calendar mode=day date=startdate>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testDay", "Must display day-view", result) 
        
    def testWeek(self):
        
        template = HTML("""\
            <dtml-calendar mode=week date=startdate>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testWeek", "Must display week-view", result) 
        
    def testYear(self):
        
        template = HTML("""\
            <dtml-calendar mode=year date=startdate>
                <dtml-var date fmt="%d">
            </dtml-calendar>""")
        result = template(**self.d)
        self.outputResults("testYear", "Must display year-view", result) 
        
    def outputResults(self, testName, description, result):

        global output
        output.write("<h1>%s</h1><p>%s</p>" % (testName, description))
        output.write(result)
        output.write("\n<!-- ==================================== -->\n")
        output.flush()

output.write("<meta http-equiv='Content-Type' value='text/html; charset=UTF-8' />")
output.write("<base href='' />")
unittest.main()

