########################################################################
#
#	ColorPickerTag.py
#
#	(c) Cognoware Australia P/L
#
#	Author: Chui Tey <teyc@bigfoot.com>
#
#	Change History:
#
#	0.1
#
#	13-Oct-2001	First release
#
# ======================================================================
#
#  Disclaimer
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#     Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
#     Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#
#     The name of the author may not be used to endorse or promote 
#     products derived from this software without specific prior
#     written permission
#
#   THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR THEIR
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
#
# ======================================================================
__version__='0.1'

from DocumentTemplate.DT_Util	import parse_params, name_param
from DocumentTemplate.DT_String import String

class ColorPickerTag:

	# tag-name will be <dtml-colorpicker>
	name = 'colorpicker'

	# tag requires two arguments
	# <dtml-colorpicker orig_color="bg_color" control_name="'bgcolor'">
	def __init__(self, args):
		args = parse_params(args, orig_color=None, control_name=None)
		#name = name_param(args, ColorPickerTag.name, 1)
		#self.__name__ = name
		self.__name__ = 'colorpicker'
		self.args = args
		self.orig_color = args['orig_color']
		self.control_name= args['control_name']

	def render(self, md):
		name = self.__name__
		args = self.args
		args['hex_color']= ("%06x" % md[self.orig_color]).upper()
		html = """<!-- ColorPicker Tag -->
	<input type="text" size="10" 
	       name="%(control_name)s" 
	       value="0X%(hex_color)s">
        </td>
        <td>
	<table border="1" cellpadding="0" cellspacing="0"
 	       bgcolor="#%(hex_color)s"
	       id="%(control_name)s_colorpicker"> 
	  <tr>
	    <td align="center"
	        width="30">
	      <a href="#" name="pick" ID="pick" 
                          onClick="cp_input='%(control_name)s';cp.show('pick');return false">
	         &nbsp;&nbsp;pick&nbsp;&nbsp;
	      </a>
	    </td>
	  </tr>
	</table>
        </td>
			""" % args
		return html 

	__call__ = render
		
# Add our tag to DocumentTemplate known tags
# commands is a dictionary indexed by tag names DocumentTemplate knows
String.commands[ColorPickerTag.name] = ColorPickerTag

