# gdchart examples
#
# Notes:
#   - Settings made with gdchart.option() are global and persistent across
#     invocations of chart().
#   - All chart styles except PIE can accept multiple data sets (but see next
#     note)
#   - Missing data values:
#     - For pie charts, missing data values can be indicated by passing a
#       second data set; 0 or None in the second data set indicates that the
#       corresponding value in the first data set should be considered missing
#       (i.e., it won't be drawn on the chart).
#     - For other charts, None in a data set indicates a missing value.

import gdchart
import cStringIO
opt = gdchart.option

size = (250, 250)
data1 = (0.5, 0.09, 0.3, 0.75, 0.0, 0.90)
data2 = (1.9, 1.3, 1.2, 0.75, 0.1, 2.0)
data3 = (62, 71, 71, 52, 55, 48)
data4 = (42, 62, 52, 37, 52, 50)
cities = ('Chicago', 'New York', 'L.A.', 'Atlanta', 'Paris, MD\n(USA)', 'London')
days = ('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday')

# Simple chart.
# Other styles: GDC_AREA, GDC_BAR, GDC_LINE, GDC_3DAREA, GDC_3DLINE.
opt(set_color=(0xff8080, 0x8080ff, 0x80ff80))
opt(bg_color=0xffffff, plot_color=0x0000cd, line_color=0x000000)
opt(title='Simple Chart', xtitle='X Axis', ytitle='Y Axis')
gdchart.chart(gdchart.GDC_3DBAR, size, 'test1.png', cities, data1, data2)

# Floating bar chart.
# Other style: GDC_FLOATINGBAR.
al=(24, 24, 22, 21, 18, 16)
ah=(49, 47, 45, 44, 43, 44)
bl=(10, 12, 15, 16, 18, 18)
bh=(48, 47, 48, 49, 51, 53)
opt(title='Floating Bar Chart', xtitle='X Axis', ytitle='Y Axis')
gdchart.chart(gdchart.GDC_3DFLOATINGBAR, size, 'test2.png', days, (al, ah), (bl, bh))

# Pie chart
# Other style: GDC_2DPIE.
opt(bg_color=0x335599, bg_transparent=1)
opt(pie_color=(0xff8080, 0x80ff80, 0x8080ff, 0xffff80, 0xff80ff, 0x80ffff))
opt(edge_color=0x0, line_color=0xffffff)
opt(label_line=1)
opt(explode=(0,0,0,0,0,15))
opt(title='Pie Test')
gdchart.chart(gdchart.GDC_3DPIE, size, 'test3.png', cities, data2)

# Combo chart
# Other styles: GDC_COMBO_LINE_AREA, GDC_COMBO_LINE_BAR, GDC_COMBO_LINE_LINE,
#   GDC_3DCOMBO_LINE_AREA, GDC_3DCOMBO_LINE_LINE.
opt(title='Combo Chart')
opt(xtitle='', ytitle='', yaxis=0, yaxis2=0)
opt(bg_color=0x0, bg_transparent=0)
gdchart.chart(gdchart.GDC_3DCOMBO_LINE_BAR, size, 'test4.png', days, data3, data4)

# Hi-lo-close chart
# Other style: GDC_HILOCLOSE.
dates = ('Jan 1', 'Jan 8', 'Jan 15', 'Jan 22', 'Jan 29', 'Feb 5')
h1=(28,30,32,33,36,35)
l1=(24,27,28,30,31,31)
c1=(27,29,30,31,33,32)

h2=map(lambda x:0.7*x - 2, h1); h2.reverse()
l2=map(lambda x:0.5*x - 2, l1); l2.reverse()
c2=map(lambda x:0.6*x - 2, c1); c2.reverse()

opt(title='Hi-Lo-Close Chart')
opt(yaxis=1, ylabel_fmt='$%.0f ')
opt(set_color=(0x80ff80, 0xff8080, 0x8080ff, 0x808080, 0x606060, 0xa0a0a0))
opt(hlc_style=gdchart.GDC_HLC_I_CAP + gdchart.GDC_HLC_CONNECTING)

opt(format=gdchart.GDC_GIF)
out = cStringIO.StringIO()
gdchart.chart(gdchart.GDC_3DHILOCLOSE, size, out, dates, (h1,l1,c1), (h2, l2, c2))
f = open('test5.gif', 'wb')
f.write(out.getvalue())
f.close()

# Combo hi-lo-close chart
# Other styles: GDC_COMBO_HLC_AREA, GDC_COMBO_HLC_BAR, GDC_3DCOMBO_HLC_BAR.
opt(format=gdchart.GDC_JPEG)
f = open('test6.jpg', 'wb')
opt(yaxis2=1, vol_color=0x808080)
gdchart.chart(gdchart.GDC_3DCOMBO_HLC_AREA, size, f, dates, (h1,l1,c1), data3)
f.close()

