########################################################################
#
#	zgdchart.py
#
#	(c) Cognoware Australia P/L
#
#	Author: Chui Tey <teyc@bigfoot.com>
#
#	Change History:
#       0.6.2
#
#       1 Dec 2001     Bug fix: getData renders on Netscape now
#                      Fabio Forno provided HILOCLOSE methods in _chartdata
#
#	0.6.1
#
#       3  Nov 2001     Dirk Datzert <dirk.datzert@rasselstein-hoesch.de>
#                       furnished ZBabelized version with German translation
#
#       0.6
#
#	15 Oct 2001     Updated to use Mike Steed's 0.6 and Python 2.1
#			More virtual host friendly
#
#	0.5.1
#
#	30 May 2001 	Updated to use Mike Steed's 0.6
#			Supports TinyTables
#	0.5
#
#	15 Dec 2000	Updated to use Mike Steed's 0.5
#			Dtml data method can take values from url
#			index_html can now override default chart types
#				using the 'zgdchart_runtime_type' parameter
#			Updated demo
#
#	0.4.3b
#
#	26 Sep 2000	Patched in multiple series with SQL query
#
#	12 Sep 2000	Introduced technique to maintain 
#				backward compatibility in the future, 
#				using version_tuple_original
#
#	9 Sep 2000	Introduced new data method
#	31 Aug 2000	Uses CStringIO, fixed self.tempfile bug
#	29 Aug 2000	Graphs 2D and 3D chart styles
#				Fix bug in Edit Scale tab
#				Simplified form to instantiate class
#	28 Aug 2000	_chart is now thread-safe
#	18 May 2000	Urlencode encodes dates properly
#	12 Apr 2000	Fixes bugs introduced in 0.3.2
#				Improved code readability	
#
#       
#	Acknowledgements and sincere thanks!:
#	
#	Hung Jung Lu <hungjunglu@hotmail.com> (version 0.4.2.b) - new data method, RPM package
#	Andreas Furbach <andreas.furbach@eds.com> (version 0.5) - cleaner data implementation
#	Marcus Bursik <mib@geology.buffalo.edu>   		- gdchart binaries for solaris
#	Eric Maryniak <e.maryniak@pobox.com>			- xhtml compliance in demo
#
#	To do:
#		gdchartdemo.index_html is not displaying all the graphs in one go on my slow machine
#		support multiple columns on SQL queries
#		a color wheel on the editColor properties
#		dtml method creates a frame which is not removed later
#
# ======================================================================
#
#  Disclaimer
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#     Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
#     Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#
#     The name of the author may not be used to endorse or promote 
#     products derived from this software without specific prior
#     written permission
#
#   THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR THEIR
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
#
# ======================================================================
__version__='0.6.1'

import Acquisition
import AccessControl
import OFS
import urllib
import string
import cStringIO
import os
from Globals import HTMLFile, MessageDialog, Persistent
from Globals import package_home
from ImageFile import ImageFile
from DocumentTemplate.DT_Util import *
from DocumentTemplate.DT_String import String
from maybe_lock import allocate_lock

#
# In this module, extend gdchart so
# that it can render itself
#
from gdchart import *

manage_addZGDChartForm=HTMLFile('manage/addZGDChart',globals())
_chart_lock = allocate_lock()


def manage_addZGDChart(self, id, title, REQUEST=None):
	"""
	Create a ZGDChart and install it in its parent Folder
	The argument 'self' will be bound to the parent Folder.
	"""

	handle=ZGDChart(id, title)
	handle.id=id
	handle.title=title
	self._setObject(id,handle)
	if REQUEST is not None:
		return self.manage_main(self, REQUEST)

def parse_version(version):
	"""Given a version of the format 'ZGDChart 0.4.2', parse
	into a list [0.0 , 4.0, 2.0]"""
	version_numbers = string.split(version,' ')[1]
	version_numbers = string.split(version_numbers, '.')
	l=[]
	for item in version_numbers:
		try:
			l.append(float(item))
		except:
			pass
		return l

class ZGDChart(
	Acquisition.Implicit,
	Persistent,
	AccessControl.Role.RoleManager,
	OFS.SimpleItem.Item,
	OFS.ObjectManager.ObjectManager
	):
	'''
	A simple chart class which plots SQL data.
	The chart plots the first two columns of a SQL query result.

	This product uses gdchart0.94b, which in turn uses gd1.3
	The current version of gd 1.7.3 does not support gif creation due to the Unisys patent.

	Wrapper authored by <a href="mailto:teyc@bigfoot.com">Chui Tey</a>.
	
	(c) Cognoware Australia P/L

	Software is provided without warranty.

	Credits:

	gdchart 	- Bruce Verdeaime   <A HREF="http://www.fred.net/brv/chart/">http://www.fred.net/brv/chart/</A>
	
	gdchart.py	- Michael Ray Steed <A HREF="http://members.xoom.com/_XMCM/msteed/software/gdchart.html"> http://members.xoom.com/_XMCM/msteed/software/gdchart.html </A>

        zgdchart.py	- Hung Jung Lu <hungjunglu@hotmail.com> (version 0.4.2.b) - new data method, RPM package
	
	This product was created using mkproduct 0.6 and Zope Simple Skeleton v0.2,
	written by Sebastian L&uuml;hnsdorf (<a href="mailto:basti@beehive.de">basti@beehive.de</a>)

	For help, refer to the <A href="http://localhost/HelpSys/ObjectRef/ZGDChart/hs_main">Zope help system</A>
	'''

	name	  =	'ZGDChart'
	id  	  =	'ZGDChart'
	icon	  =	'misc_/ZGDChart/Main'
	meta_type =	'ZGDChart'

	_properties = (
		{'id':'title','type':'string','mode':'w'},
		)

	manage_options=(
		{'label':'Properties' , 'icon':icon, 'action':'manage_main',        'target':'_self', 'help': ('ZGDChart','ZGDChart_Properties.stx')},
		{'label':'Colors'     , 'icon':icon, 'action':'manage_mainColor',   'target':'_self', 'help': ('ZGDChart','ZGDChart_Colors.stx')},
		{'label':'Scale',       'icon':icon, 'action':'manage_mainScale',   'target':'_self', 'help': ('ZGDChart','ZGDChart_Scale.stx')},
		{'label':'Data Method', 'icon':icon, 'action':'manage_mainGetData', 'target':'_self', 'help': ('ZGDChart','ZGDChart_DataMethod.stx')},
		{'label':'Security'   , 'icon':icon, 'action':'manage_access',      'target':'_self', 'help': ('ZGDChart','ZGDChart_Security.stx')},
		{'label':'View'       , 'icon':icon, 'action':'manage_mainView',    'target':'_self'},
		)

	__ac_permissions__=(
		('View management screens',('manage_tabs','manage_main')),
		('Change permissions',('manage_access',)),
		('Change ZGDChart',('manage_edit','manage_editColor'),('Manager',)),
		)

	chart_types = [
		'Area_3D',
		'Bar_3D',
		'Line_3D',
		'Pie_3D',
		'Hi_Lo_Close_3D',
		'Combo_Line_Area_3D',
		'Combo_Line_Bar_3D',
		'Combo_HLC_Area_3D',
		'Combo_HLC_Bar_3D',
		'Area_2D',
		'Bar_2D',
		'Line_2D',
		'Pie_2D',
		'Hi_Lo_Close_2D',
		'Combo_Line_Area_2D',
		'Combo_Line_Bar_2D',
		'Combo_HLC_Area_2D',
		'Combo_HLC_Bar_2D',
		]

	chart_type_codes = {
		'Area_2D': 				GDC_AREA,
		'Bar_2D': 				GDC_BAR,
		'Line_2D': 				GDC_LINE,
		'Pie_2D': 				GDC_2DPIE, 
		'Hi_Lo_Close_2D': 		GDC_HILOCLOSE,
		'Combo_Line_Area_2D':	GDC_COMBO_LINE_AREA,
		'Combo_Line_Bar_2D':	GDC_COMBO_LINE_BAR,
		'Combo_HLC_Area_2D': 	GDC_COMBO_HLC_AREA,
		'Combo_HLC_Bar_2D':		GDC_COMBO_HLC_BAR,
		'Area_3D': 				GDC_3DAREA,
		'Bar_3D': 				GDC_3DBAR,
		'Line_3D': 				GDC_3DLINE,
		'Pie_3D': 				GDC_3DPIE,
		'Hi_Lo_Close_3D': 		GDC_3DHILOCLOSE,
		'Combo_Line_Area_3D': 	GDC_3DCOMBO_LINE_AREA,
		'Combo_Line_Bar_3D': 	GDC_3DCOMBO_LINE_BAR,
		'Combo_HLC_Area_3D': 	GDC_3DCOMBO_HLC_AREA,
		'Combo_HLC_Bar_3D': 	GDC_3DCOMBO_HLC_BAR,
		}

	chart_parameters = [
		'annotation_font',
		'bar_width',
		'bg_color',
		'bg_transparent',
		'border',
		'edge_color',
		'explode',
		'ext_color',
		'ext_vol_color',
		'format',
		'generate_gif',
		'grid',
		'grid_color',
		'hard_graphheight',
		'hard_graphwidth',
		'hard_size',
		'hard_xorig',
		'hard_yorig',
		'hlc_cap_width',
		'hlc_style',
		'hold_img',
		'label_dist',
		'label_font',
		'label_line',
		'line_color',
		'other_threshold',
		'percent_labels',
		'pie_color',
		'plot_color',
		'requested_ymax',
		'requested_ymin',
		'requested_yinterval',
		'set_color',
		'stack_type',
		'thumblabel',
		'thumbnail',
		'thumbval',
		'threed_angle',
		'threed_depth',
		'title',
		'title_color',
		'title_font',
		'vol_color',
		'xaxis',
		'xaxis_font',
		'xlabel_color',
		'xlabel_spacing',
		'xtitle',
		'xtitle_color',
		'xtitle_font',
		'yaxis',
		'yaxis2',
		'yaxis_font',
		'ylabel_color',
		'ylabel_density',
		'ylabel_fmt',
		'ylabel2_color',
		'ylabel2_fmt',
		'ytitle',
		'ytitle_color',
		'ytitle_font',
		'ytitle2',
		'ytitle2_color',
		'zeroshelf',		
		]
	
	# External HTML files
	
	manage_main = HTMLFile('manage/edit', globals())
	manage_mainColor = HTMLFile('manage/editColor', globals())
	manage_mainScale = HTMLFile('manage/editScale', globals())
	manage_mainGetData = HTMLFile('manage/getData', globals())
	manage_mainView = HTMLFile('manage/view', globals())
	upper_manage_mainGetData = HTMLFile('manage/getData', globals())
	lower_manage_mainSelectZsql = HTMLFile('manage/getZsqlData', globals())

	# REQUEST runtime parameter prefix
	runtime_prefix = 'zgdchart_runtime_'

	def home(self):
		"returns the directory where the product is located in"
		return package_home(globals())
	
	def version (self):
		"Return the version number of this product"		
		return open(self.home() + '/version.txt').read()
	
	def version_tuple(self):
		return parse_version(self.version())

	def __init__(self, id='ZGDChart', title='ZGDChart', height=250, width=250, 
		SQL=None, chart_type='Bar_3D', option=['xaxis', 'yaxis', 'grid', 'border']):
		
		self.id 	    	= id
		self.title  	   	= title
		self.height 	   	= height
		self.width  	   	= width
		self.SQL    	   	= SQL
		self.TinyTable    	= None
		self.content_type	= 'image/gif'
		self.tempfile		= self.home() + '/temp.gif'
		self.version_tuple_original   = self.version_tuple()	#store the version number of the current instance
	
		# Set the chart options
		self.bg_transparent	= 'bg_transparent' in option
		self.xaxis    		= 'xaxis' in option
		self.yaxis      	= 'yaxis' in option
		self.yaxis2			= 'yaxis2' in option
		self.label_line		= 'label_line' in option
		self.grid			= 'grid' in option
		self.border			= 'border' in option
		self.thumbnail		= 'thumbnail' in option
		self.chart_type		= chart_type

		# Set the chart color
		self.bg_color		=0xFFFFFF
		self.title_color	=0x446688
		self.edge_color		=0x000000
		self.grid_color		=0x446688
		self.plot_color		=0x446688
		self.line_color		=0x446688
		self.xlabel_color	=0x446688
		self.ylabel_color	=0x446688
		self.ylabel2_color	=0x446644
		self.xtitle_color	=0x446688
		self.ytitle_color	=0x446688
		self.ytitle2_color	=0x446644
		self.vol_color		=0x000000

		# ---------------------------------
		# Declare these variables because
		# we don't want to break compatibility
		# when these eventually get implemented
		
		# Set chart text
		self.charttitle = title
		self.xtitle		= ''
		self.ytitle		= ''
		self.ytitle2	= ''
		self.thumblabel = ''

		# Set chart text font sizes
		self.title_font			= GDC_LARGE
		self.xtitle_font		= GDC_SMALL
		self.ytitle_font		= GDC_SMALL
		self.ytitle2_font		= GDC_SMALL
		self.xaxis_font			= GDC_SMALL
		self.yaxis_font			= GDC_SMALL
		self.label_font			= GDC_SMALL
		self.annotation_font	= GDC_SMALL

		# Set miscellaneous items
		self.bar_width			=	10
		self.explode 			=	[0,0,0]
		self.ext_color			=	[0,0,0]
		self.ext_vol_color 		=	[0,0,0]
		self.generate_gif		=	1
		self.hard_graphheight	=	300
		self.hard_graphwidth	= 	400
		self.hard_size			=	0
		self.hard_xorig			=	0
		self.hard_yorig			=	0
		self.hlc_cap_width		=	0
		self.hlc_style			=	GDC_HLC_I_CAP + GDC_HLC_CONNECTING
		self.hold_img			=	0
		self.missing			= 	[]
		self.other_threshold	= 	10
		self.percent_labels		=	GDCPIE_PCT_NONE
		self.pie_color			= 	[0x88ff88, 0x8888ff, 0xff8888, 0xffff88, 0x88ffff, 0xff88ff]
		self.set_color			=	[0x8888ff, 0x88ff88, 0xff8888, 0x3388aa, 0xaa8833, 0x88aa33]
		self.stack_type			=	GDC_STACK_BESIDE
		self.thumbval			=	0
		self.zeroshelf			=	0
		
		# Set axis
		self.requested_ymax			=	None
		self.requested_ymin			=	None
		self.requested_yinterval	=	None
		self.xhist_interval			=	None
		self.label_dist				=	None
		self.xlabel_spacing			=	5.0
		self.ylabel_density			=	80.0
		self.ylabel_fmt				=	''
		self.ylabel2_fmt			=	''
		
		# Set three dimensional properties		
		self.threed_angle		=	0
		self.threed_depth		=	0

		# Set the data gathering method
		self.selected_data_method = 'dtml'
		f = open(os.path.join(self.home(),'manage', 'getDtmlData.dtml'), 'r')
		getDtmlData_dtml = f.read()
		f.close()
		ob = OFS.DTMLMethod.DTMLMethod(getDtmlData_dtml, __name__='getDtmlData')
		self._setObject('getDtmlData', ob)
			
	def _upgrade(self):
		""" Technique to bring old instances up to date with any new required attributes """
		if not hasattr(self, 'selected_data_method'):
		     self.selected_data_method = 'zsql'
		if not hasattr(self, 'set_color_list'):
		     self.set_color_list = self.pie_color
		if not hasattr(self, 'set_color'):
		     self.set_color = self.pie_color
		if not hasattr(self, 'TinyTable'):
		     self.TinyTable = None
		self.version_tuple_original = self.version_tuple()

	def __setstate__(self, state):               
		Persistent.__setstate__(self, state) # Important, always call this
		# Check if we need to upgrade the current instance
		#
		if hasattr(self, 'version_tuple_original'):
			if self.version_tuple_original < self.version_tuple():
				self._upgrade()
		else:
			self.upgrade() # heh, must be a very old version
			
	def manage_edit(self, title, xtitle, ytitle, width, height, chart_type, option=[], REQUEST=None):
		"""edit ZGDChart"""
		self.title      	= title
		self.xtitle     	= xtitle
		self.ytitle			= ytitle
		self.height     	= height
		self.width      	= width
		self.chart_type 	= chart_type
		self.bg_transparent = 'bg_transparent' in option
		self.label_line     = 'label_line' in option
		self.thumbnail 	    = 'thumbnail' in option
		self.border     	= 'border' in option
		self.grid	    	= 'grid' in option
		self.xaxis      	= 'xaxis' in option
		self.yaxis      	= 'yaxis' in option
		self.yaxis2     	= 'yaxis2' in option

		if REQUEST is not None:
			return MessageDialog(
				title='Edited',
				message='<strong>%s</strong> has been edited.' % self.id,
				action = './manage_main'
				)

	def manage_editColor(self, bg_color, edge_color, grid_color, plot_color,
						 title_color, xtitle_color, ytitle_color, ytitle2_color,
						 xlabel_color, ylabel_color, ylabel2_color, set_color_list,
						 pie_color_list,
						 REQUEST=None):
		""" edit ZGDChart colors
			all values to be passed as strings in hex, eg..
			manage_editColor(bg_color = "0xFFFFFF")
		"""
		self.bg_color   	= string.atoi(bg_color,   16)
		self.edge_color 	= string.atoi(edge_color, 16)
		self.grid_color 	= string.atoi(grid_color, 16)
		self.plot_color 	= string.atoi(plot_color, 16)
		self.title_color	= string.atoi(title_color, 16)
		self.xtitle_color 	= string.atoi(xtitle_color, 16)
		self.ytitle_color 	= string.atoi(ytitle_color, 16)
		self.ytitle2_color 	= string.atoi(ytitle2_color, 16)
		self.xlabel_color	= string.atoi(xlabel_color, 16)
		self.ylabel_color 	= string.atoi(ylabel_color, 16)
		self.ylabel2_color	= string.atoi(ylabel2_color, 16)
		self.set_color		= map(lambda x:string.atoi(x,16), string.split(set_color_list, ','))
		self.pie_color		= map(lambda x:string.atoi(x,16), string.split(pie_color_list, ','))
		
		if REQUEST is not None:
			return MessageDialog(
				title='Edited',
				message='<strong>%s</strong> has been edited.' % self.id,
				action = './manage_mainColor'
				)

	def manage_editScale(self,
				 requested_ymax=None, requested_ymin=None, requested_yinterval=None,
				 xlabel_spacing=5, ylabel_density=80,
				 ylabel_fmt='', ylabel2_fmt='', REQUEST=None):
		""" edit ZGDChart scale properties """		
		self.xlabel_spacing			=	xlabel_spacing
		self.requested_ymax			=	requested_ymax		
		self.requested_ymin			=	requested_ymin
		self.requested_yinterval	=	requested_yinterval
		self.ylabel_density			=	ylabel_density
		self.ylabel_fmt				=	ylabel_fmt
		self.ylabel2_fmt			=	ylabel2_fmt

		if REQUEST is not None:
			return MessageDialog(
				title='Edited',
				message='<strong>%s</strong> has been edited.' % self.id,
				action = './manage_mainScale'
				)

	def manage_changeDataMethod(self, data_method, REQUEST=None):
		"""change Data Method"""
		self.selected_data_method = data_method
		if REQUEST is not None:
			return MessageDialog(
				title='Data Method Changed',
				message='Data Method for <strong>%s</strong> has been changed.' % self.id,
				action = './manage_mainGetData',
				target = 'manage_main'
				)

	def manage_selectSQL(self, SQL, REQUEST=None):
		"""select SQL"""
		self.SQL = SQL
		if REQUEST is not None:
			return MessageDialog(
				title='Selected',
				message='Selection has been recorded.',
				action = './manage_mainGetData',
				target = 'manage_main'
				)

	def manage_selectTinyTable(self, TinyTable, Columns=[], Filter={}, REQUEST=None):
		"""select TinyTable as data source"""
		# Columns and Filter are unused at the moment
		self.TinyTable = TinyTable
		self.TinyTable_columns = Columns
		self.TinyTable_filter = Filter
		if REQUEST is not None:
			return MessageDialog(
				title='Selected',
				message='Selection has been recorded.',
				action = './manage_mainGetData',
				target = 'manage_main'
				)

	def __call__(self, mapping={}, **kwargs):
		''' Just another version of __str__ '''
		# Not sure if this is going to block other inherited methods

		# combine mapping and kwargs into a single dictionary
		dict = {}
		for key,value in mapping.items():
			dict[key]=value
		for key,value in kwargs.items():
			dict[key]=value
		
		# roll our own urlencode because we want
		# / to be encoded
		# query = urllib.urlencode(kwargs)
		query = self.urlencode(dict)

		#
		# get the actual path to the object in case we are
		# not calling from the same directory
		#
		path = string.join(self.getPhysicalPath(), '/')
		return '<IMG SRC="%s?%s" ALT="%s">' % (path, query, self.title)

	def urlencode(self, dict):
		#
		# have to quote lists and tuples in format Zope understands
		# therefore test for types in dictionary
		#
		from types import ListType, TupleType
		
		l = []
		#import pdb; pdb.set_trace()
		for k, v in dict.items():
			
			if type(v) is ListType or type(v) is TupleType:
				k = urllib.quote_plus(str(k+':tokens'))
				v_str = ""
				for item in v:
					v_str = v_str + "+" + urllib.quote_plus(str(item))
				l.append(k + '=' + v_str)
			else:
				k = urllib.quote_plus(str(k))
				v = urllib.quote_plus(str(v),'')
				l.append(k + '=' + v)

		return string.join(l, '&')

	# following routines are inspired by Arpad Kiss's chart product
	def __str__(self,REQUEST=None,RESPONSE=None):
		"""
		Returns a string representation of the object <IMG SRC=xxx>
		"""
		return '<IMG SRC="%s" ALT="%s">' % (self.id, self.title)
	
	def index_html(self,REQUEST=None,RESPONSE=None):
		"""
		This is the default method.
		"""
		#
		# The default chart type can be overridden by passing
		# zgdchart_runtime_type = 'Bar_2D' etc.
		#
		if REQUEST:
			if hasattr(REQUEST, self.runtime_prefix + 'type'):
				return self._chart(ZGDChart.chart_type_codes[REQUEST[self.runtime_prefix + 'type']], RESPONSE)		
		#
		# return the default chart
		#
		return self._chart(ZGDChart.chart_type_codes[self.chart_type], RESPONSE)

	#
	#	Methods of a ZGDChart instance
	#	returns a chart
	#
	#	The first few methods area inconsistent
	#	in their implementations of 2D and 3D
	#	charts. Leave them unchanged to preserve
	#	backward compatibility
	#
	def Area(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		Deprecated
		"""
		return self._chart(GDC_AREA, RESPONSE)

	def Bar(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		Deprecated
		"""
		return self._chart(GDC_BAR, RESPONSE)

	def Line(self,REQUEST=None,RESPONSE=None):
		"""
		Renders dataset as a line chart
		Deprecated
		"""
		return self._chart(GDC_LINE, RESPONSE)

	def Pie(self,REQUEST=None,RESPONSE=None):
		"""
		Renders dataset as a pie chart
		Deprecated
		"""
		return self._chart(GDC_3DPIE, RESPONSE)

	#
	#	Implements the new naming API
	#

	def Area_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		"""
		return self._chart(GDC_AREA, RESPONSE)

	def Bar_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		"""
		return self._chart(GDC_BAR, RESPONSE)

	def Line_2D(self,REQUEST=None,RESPONSE=None):
		"""
		Renders dataset as a line chart
		"""
		return self._chart(GDC_LINE, RESPONSE)

	def Pie_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 2D pie chart
		"""
		return self._chart(GDC_2DPIE, RESPONSE)
			
	def Area_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D area chart
		"""
		return self._chart(GDC_3DAREA, RESPONSE)
			
	def Bar_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D bar chart
		"""
		return self._chart(GDC_3DBAR, RESPONSE)

	def Line_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D line chart
		"""
		return self._chart(GDC_3DLINE, RESPONSE)
			
	def Pie_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D pie chart
		"""
		return self._chart(GDC_3DPIE, RESPONSE)

	def Hi_Lo_Close_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a hi lo close chart
		"""
		return self._chart(GDC_HI_LO_CLOSE, RESPONSE)		
	
	def Hi_Lo_Close_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of Hi_Lo_Close
		"""
		return self._chart(GDC_3DHILOCLOSE, RESPONSE)

	#	XXX To do: Hack chartdata to
	#	           handle combo charts
	#
	def Combo_Line_Area_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of line and area chart
		"""
		return self._chart(GDC_COMBO_LINE_AREA, RESPONSE)

	def Combo_Line_Bar_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of line and bar chart
		"""
		return self._chart(GDC_COMBO_LINE_BAR, RESPONSE)

	def Combo_HLC_Area_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of hi lo close and area chart
		"""
		return self._chart(GDC_COMBO_HLC_AREA, RESPONSE)

	def Combo_HLC_Bar_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of hi lo close and bar chart
		"""
		return self._chart(GDC_COMBO_HLC_BAR, RESPONSE)

	def Combo_Line_Area_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of line and area chart
		"""
		return self._chart(GDC_3DCOMBO_LINE_AREA, RESPONSE)
			
	def Combo_Line_Bar_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of line and area bar
		"""
		return self._chart(GDC_3DCOMBO_LINE_BAR, RESPONSE)
			
	def Combo_HLC_Area_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of HLC and area chart
		"""
		return self._chart(GDC_3DCOMBO_HLC_AREA, RESPONSE)
			
	def Combo_HLC_Bar_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of HLC and area bar
		"""
		return self._chart(GDC_3DCOMBO_HLC_BAR, RESPONSE)
			
	def _chart(self, GDC_TYPE, RESPONSE=None):
		"""
		Renders dataset in the format requested
		"""
		self.REQUEST[self.runtime_prefix + 'type'] = GDC_TYPE

		# 
		# Two methods are available for 
		# selection of chart data
		#
		if self.selected_data_method == 'dtml':
			chartdata = self.getDtmlData(self, self.REQUEST, RESPONSE)
		elif self.selected_data_method == 'tinytable':
			chartdata = self._chartdata_TinyTable()
		elif self.selected_data_method == 'zsql':
			chartdata = self._chartdata_SQL()

		try:
			_chart_lock.acquire()
			self._setOption()
			self._setColor()
			self._setScale()
			#
			# requires GDChart 0.4
			#
			tempfile = cStringIO.StringIO() 
			apply(chart, (GDC_TYPE, (self.width, self.height), tempfile) + tuple(chartdata))
			if RESPONSE: RESPONSE['content-type']=self.content_type
			output = tempfile.getvalue()

		finally:
			_chart_lock.release()			
		return  output
		
	def _setOption(self):
		params = {}
		p = self.runtime_prefix

		for s in ('title', 'xtitle', 'ytitle',):
			if self.REQUEST.has_key(p+s):
				params[s] = self.REQUEST[p+s]
			else:
				params[s] = getattr(self, s)
				
		for s in ('bg_transparent', 'xaxis', 'yaxis', 'yaxis2', 'label_line', 'grid',
				  'border', 'thumbnail', 'hlc_style',):
			if self.REQUEST.has_key(p+s):
				params[s] = int(self.REQUEST[p+s])
			else:
				params[s] = getattr(self, s)

		for s in params.keys():
			eval("option(%s = params['%s'])" % (s,s))
	
	def _setColor(self):

		params = {}
		p = self.runtime_prefix

		for s in ('bg_color', 'grid_color', 'plot_color', 'edge_color', 'title_color',
				  'xtitle_color', 'ytitle_color', 'ytitle2_color', 'xlabel_color',
				  'ylabel_color', 'ylabel2_color',):
			if self.REQUEST.has_key(p+s):
				if type(self.REQUEST[p+s]) == type(''):
					params[s] = string.atoi(self.REQUEST[p+s],16)
				else:
					params[s] = self.REQUEST[p+s]
			else:
				params[s] = getattr(self, s)

		for s in ('set_color', 'pie_color',):
			if self.REQUEST.has_key(p+s):
				if type(self.REQUEST[p+s]) == type(''):
					params[s] = map(lambda x:string.atoi(x,16), string.split(self.REQUEST[p+s], ','))
				else:
					params[s] = self.REQUEST[p+s]
			else:
				params[s] = getattr(self, s)

		for s in params.keys():
			eval("option(%s = params['%s'])" % (s,s))

	def _setScale(self):

		params = {}
		p = self.runtime_prefix

		for s in ('requested_ymax', 'requested_ymin', 'requested_yinterval',
				  'xlabel_spacing', 'ylabel_density',):
			if self.REQUEST.has_key(p+s):
				params[s] = float(self.REQUEST[p+s])
			else:
				params[s] = getattr(self, s)
	
		#
		#  the only possible way to reset the scaling options
		#  to default values is to use a patched gdchart.pyd,
		#  and pass None as a parameter. self.requested_ymax and
		#  other attributes in the following block may be a None
		#
		try:
			for s in params.keys():
				eval("option(%s = params['%s'])" % (s,s))
		except error:
			#
			#  probably haven't got a patched gdchart.pyd
			#  will try to run gdchart using previous scale settings
			#  it will be ugly but at least won't give an error page
			#
			#  XXX log this to a file?
			#
			print "GDChart setscale error"
			pass
			
		params = {}
		p = self.runtime_prefix
		
		for s in ('ylabel_fmt', 'ylabel2_fmt',):
			if self.REQUEST.has_key(p+s):
				params[s] = self.REQUEST[p+s]
			else:
				params[s] = getattr(self, s)

		for s in params.keys():
			eval("option(%s = params['%s'])" % (s,s))

	def _chartdata(self, rows):
                """
                return the first and second columns of sql query
                results as a pair of tuples
                """
                # rows = getattr(self, self.SQL)()
                # data[0] is list of labels
                zgdchart_runtime_type=self.REQUEST[self.runtime_prefix+'type'] 
                print "chartdata type: " , zgdchart_runtime_type
                data =  []
                start = 0
                for row in rows:
                        # each row is a list of fields
                        # initialize empty lists for each column
                        if start == 0:
                          start = 1
                          for i in range(len(row)):
                            data.append([])
                        #
                        # Only insert rows with zero values if
                        # it is not a pie chart
                        # Pie Chart only makes sense with 1 data column
                        #
                        for i in range(len(row)):
                            if (zgdchart_runtime_type!= GDC_3DPIE \
                               and zgdchart_runtime_type != GDC_2DPIE) \
                               or row[1] != 0:
                              #
                              # Coerce the first field into a string
                              # and other fields into a float
                              #
                              if i == 0:
                                  data[i].append( str  (row[i]))
                              else:
                                  data[i].append( float(row[i]))

                # Fabio Forno's patch for handling HILOCLOSE types
                #
                if zgdchart_runtime_type in \
                    (GDC_3DHILOCLOSE,     \
                     GDC_HILOCLOSE,       \
                     GDC_3DCOMBO_HLC_AREA,\
                     GDC_3DCOMBO_HLC_BAR, \
                     GDC_COMBO_HLC_AREA,  \
                     GDC_COMBO_HLC_BAR) and len(data) >=4:
                     #
                     # Hi-Lo-Close format 
                     # [labels], ([hi],[lo],[close]), [combo]
                     #
                     _data=[]
                     _data.append(data[0])           # copy labels
                     _data.append(tuple(data[1:4]))  # hi-lo-close
                     if len(data) >= 5 and        \
                        zgdchart_runtime_type in  \
                           (GDC_3DCOMBO_HLC_AREA, \
                            GDC_3DCOMBO_HLC_BAR,  \
                            GDC_COMBO_HLC_AREA,   \
                            GDC_COMBO_HLC_BAR):
                                # use spare column for combos 
                                _data.append (data[4])
                     data = _data
                return data

	def _chartdata_SQL(self):
		SQL = getattr(self, self.SQL)
		rows = SQL()
		return self._chartdata(rows)

	def _chartdata_TinyTable(self):
		#
		# gets chart data from Tiny Table
		# uses self.TinyTable
		#      self.TinyTable_columns - list
		#      self.TinyTable_filter  - dict
		#
		TinyTable = getattr(self, self.TinyTable)
		rows = apply(TinyTable, self.TinyTable_filter)
		return self._chartdata(rows)

	# XXX not a good idea? hit SQL servers too many times
	def _labels(self):
		"""
		return the first column sql query results as a tuple
		"""
		rows = getattr(self, self.SQL)()
		tmp=()
		for row in rows:
		   tmp = tmp + (row[0],)
		return tmp
		
	def _data(self):
		rows = getattr(self, self.SQL)()
		tmp=()
		for row in rows:
		    tmp = tmp + (row[1],)
		return tmp


# External Javascript files
# TODO: Refactor this into the ColorPickerTag
setattr(ZGDChart,'AnchorPosition.js',ImageFile('manage/AnchorPosition.js', globals()))
setattr(ZGDChart,'PopupWindow.js',ImageFile('manage/PopupWindow.js', globals()))
setattr(ZGDChart,'ColorPicker.js',ImageFile('manage/ColorPicker.js', globals()))

