
__doc__ = """BeingBeingBoring product module.

See README.txt for more details."""


__version__ = '0.0.3'

from Globals import HTMLFile
from Globals import MessageDialog
from Globals import Persistent

import OFS.SimpleItem
import Acquisition
import AccessControl.Role
from Products.ExtendedManagmentTabs import ExtendedManagmentTabs

manage_addBeingBoringForm = HTMLFile('BeingBoringAdd', globals()) 

def manage_addBeingBoring(self, id, title='', REQUEST=None):
    """Add a BeingBoring to a folder."""
    self._setObject(id, BeingBoring(id, title))
    if REQUEST is not None:
        return self.manage_main(self, REQUEST)


class BeingBoring(
    ExtendedManagmentTabs.ExtendedManagmentTabs,
    OFS.SimpleItem.Item,  
    Persistent,           
    Acquisition.Implicit, 
    AccessControl.Role.RoleManager 
    ): 
    """BeingBoring object. 
    """
        
    meta_type = 'BeingBoring'

    deep_manage_options = ( 
            {'label': 'My Menu4',       'action': 'meny4'},
            {'label': 'My Menu5',       'action': 'meny5'}, 
            {'label': 'My Menu6',       'action': 'meny6'},
        ) 

    my_manage_options = ( 
            {'label': 'My Menu1',       'action': 'meny1',  'submenu': deep_manage_options , 'help':('BeingBoring','meny1.stx')},
            {'label': 'My Menu2',       'action': 'meny2', 'help':('BeingBoring','meny2.stx')}, 
            {'label': 'My Menu3',       'action': 'meny3'},
        ) 

    manage_options = ( 
            {'label': 'Edit',       'action': 'manage_main',    'submenu': my_manage_options, 'help':('BeingBoring','manage_main.stx') },
            {'label': 'View',       'action': 'index_html'}, 
            {'label': 'Security',   'action': 'manage_access'},
        ) 


    _v_manage_options_label_index = ExtendedManagmentTabs.createManageIndex(manage_options=manage_options)

    __ac_permissions__=( 
    ('View management screens', ('manage_tabs','manage_main')),
    ('Change permissions',      ('manage_access',)           ),
    ('Change BeingBorings'     ,     ('manage_edit',)             ),
    ('View BeingBorings',            ('',)                        ),
    )

    def __init__(self, id, title=''): 
        """initialise a new instance of BeingBoring"""
        self.id = id
        self.title = title

    index_html = HTMLFile('index', globals()) 
    
    meny1 = index_html
    meny2 = index_html
    meny3 = index_html
    meny4 = index_html
    meny5 = index_html
    meny6 = index_html
    
    manage_main = HTMLFile('BeingBoringEdit', globals()) 
    
    def manage_edit(self, title, REQUEST=None): 
        """does this really need a doc string?"""
        self.title = title
        if REQUEST is not None:
            return self.manage_main(self,REQUEST,management_view='Edit')

    def save(self, title='', REQUEST=None): 
        """does this really need a doc string?"""
        self.title = title
        if REQUEST is not None:
            return self.meny1(self,REQUEST,management_view=('Edit','My Menu1','My Menu5'))
