from DocumentTemplate.DT_Util import TemplateDict,InstanceDict
from ExtensionClass import Base
from Acquisition import Implicit

class FunctionTemplate(Implicit):
    """A wrapper to use a python function as a Document Template.
    This is useful if you want to promote a DTMLMethod into a python function
    (to better handle complex logic) but to not want to loose context-oriented
    nature of DTML.
    """

    isDocTemp=1

    # Prevent acquisition from our container
    index_html=None

    # Templates masquerade as functions:
    class func_code: pass
    func_code=func_code()
    func_code.co_varnames='self','REQUEST'
    func_code.co_argcount=2
    func_defaults=()

    # Only used for wrapping trusted content
    validate = None 
    
    def __init__(self,fn,**globals):
        self._fn = fn
        self._globals = globals

    def __call__(self,client=None,context={},**extras):
        md = TemplateDict()
        md.validate = self.validate
        md._push(self._globals)
        if context:
            md._push(context)
        if client is not None:
            md._push(InstanceDict(client, md)) # Circ. Ref. 8-|
        if extras:
            md._push(extras)
        try:
            real_self = self.aq_inner.aq_parent
            fn = self._fn
            return fn(real_self,md)
        finally:
            while md:
                md._pop()

