__version = '$ Release 0.4.3 $'[-7:-2]

############################################################################### 
#
# Copyright (c) 1999 Andrew Lahser
# All rights reserved. Written by Andrew Lahser andrew@apl-software.com
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions 
# are met: 
# 1. Redistributions of source code must retain the above copyright 
#    notice, this list of conditions and the following disclaimer. 
# 2. Redistributions in binary form must reproduce the above copyright 
#    notice, this list of conditions and the following disclaimer in the 
#    documentation and/or other materials provided with the distribution. 
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission 
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
#   
#  In accordance with the license provided for by the software upon 
#  which some of the source code has been derived or used, the following 
#  acknowledgement is hereby provided : 
# 
#      "This product includes software developed by Digital Creations 
#      for use in the Z Object Publishing Environment 
#      (http://www.zope.org/)." 
#  
############################################################################### 

# TODO
#
#  * PTK Integration!
#  * Investigate FlashPix - are there server-side requirements that
#    would mean extending ZServer? probably not what we want.
#  * Convert to Imagemagick!!
#  * Rotate (Translate)
#  * Add Border, specify color
#      Increase Canvas Size by 102%
#  * The following Unsharp Mask (Photoshop filter) settings generally
#    improve an image after resizing. Similar results should be 
#    possible using Sharpen. 
#      Amount 100, Radius .25, Threshold 2 for 128x192
#      Amount 100, Radius 0.5, Threshold 2 for 256,384
#      Amount 100, Radius 1.0, Threshold 2 for 512x768
#      Amount 100, Radius 2.0, Threshold 2 for 1024x1536
#      Amount 100, Radius 4.0, Threshold 2 for 2kx3k
#
#  * Append Copyright Text to specific display sizes, see TTimage?
#
#  * Batch Process, 
#    Resize, Sharpen, Border, Copyright text
#
# End of TODO

# Wow. I have imported lots of stuff. I wonder if this is smart. Actually, I 
# wonder if I really need all of this stuff. 
# Also, I am wondering if it's better to use "import"  or "from ... import ..."
# Stylistically, I like the "from ... import ...", but I bet there is more to it.



from OFS.content_types    import guess_content_type
from OFS.Image            import Image, cookId, Pdata
from Globals              import HTMLFile, MessageDialog, Persistent
from OFS.PropertyManager  import PropertyManager
from OFS.ObjectManager    import ObjectManager
from OFS.SimpleItem       import SimpleItem, Item_w__name__
from AccessControl.Role   import RoleManager
from webdav.common        import rfc1123_date
from cStringIO            import StringIO
from Acquisition          import Implicit
from DateTime             import DateTime
from types                import IntType, StringType, TupleType
from urllib               import quote, unquote
from Products.ZCatalog    import ZCatalog
from OFS.FindSupport      import FindSupport
from PIL.Image            import BICUBIC, BILINEAR, NEAREST
from Products.ZCatalog.CatalogAwareness    import CatalogAware

import Globals, string, struct, OFS.content_types
import PIL

# Notes on PIL:
# 1. Seems fast
# 2. Quality seems fair, imagemagick seems to do a better job, but 
#    Photoshop is better still. 
# 3. No support for FlashPix, Imagemagick has support. Still Zope doesn't
#    *seem* to be able to serve up FlashPix. I really don't care that much.
#    Yet.
# 4. Hard to install, but no obvious way to make Imagemagick installation 
#    easier. 
# 5. Compatible with Python, stable. Imagemagick's interface seems half baked,
#    and it's probably not worth my time to look into fixing that interface.
# 6. Imagemagick's feature set is impressive, but it makes you wonder abou
#    feature creep. Do open source solutions tend towards feature creep?
# 7. Without input to contrary, will move to Imagemagick.

manage_addPhotoForm=HTMLFile('PhotoAdd', globals(), Kind='Photo', kind='Photo')
display_defaults={ 
	      'thumbnail':{'actual' : (0,0), 'target' : (128,128),  'size' : 0},
              'preview'  :{'actual' : (0,0), 'target' : (370,263),  'size' : 0},
              'webtv'    :{'actual' : (0,0), 'target' : (544,378),  'size' : 0},
              'xsmall'   :{'actual' : (0,0), 'target' : (623,278),  'size' : 0},
              'small'    :{'actual' : (0,0), 'target' : (783,398),  'size' : 0},
              'medium'   :{'actual' : (0,0), 'target' : (1007,566), 'size' : 0},
              'large'    :{'actual' : (0,0), 'target' : (1135,668), 'size' : 0},
              'xlarge'   :{'actual' : (0,0), 'target' : (1263,822), 'size' : 0},
              }

def manage_addPhoto(self, id, file, title='', displays=None, precondition='', 
                    content_type='', REQUEST=None):
    """
    Add a new Photo object.
    """
    # This constructor basically ripped off from Image/File
    id, title = cookId(id, title, file)
    self=self.this()
    # First, we create the photo without data:
    self._setObject(id, Photo(id,title,'',displays,content_type,precondition))
    # Now we "upload" the data.  By doing this in two steps, we
    # can use a database trick to make the upload more efficient.
    self._getOb(id).manage_upload(file)
    if REQUEST:
        try:    url=self.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect('%s/manage_main' % url)
    return id
 
class Photo(Image):
    """
    Photo objects are images. Each Photo will save itself at a variety
    of display sizes for fast and easy retrieval from the web.
    """
    meta_type='Photo'
    manage_displays=HTMLFile('displays',globals())
# Bad form to leave in commented code. 20000113-apl
# Shame on me. This ties in with another section below.
#    manage_resize=HTMLFile('resize',globals())
#    manage_transpose=HTMLFile('transpose',globals())
    manage_options=({'label':'Edit', 'action':'manage_main'},
                    {'label':'Upload', 'action':'manage_uploadForm'},
                    {'label':'Displays', 'action':'manage_displays'},
#                    {'label':'Resize', 'action':'manage_resize'},
#                    {'label':'Transpose', 'action':'manage_transpose'},
# End commented code. 
                    {'label':'Properties', 'action':'manage_propertiesForm'},
                    {'label':'View', 'action':'view_image_or_file'},
                    {'label':'Security', 'action':'manage_access'},
                    )

    def __init__(self, id, title, file, 
                 displays = None, content_type = '', precondition = ''):
        self.__name__=id
        self.title=title
        self.precondition=precondition
        data, size = self._read_data(file)
        content_type=self._get_content_type(file, data, id, content_type)
	if displays == None:
            self.displays=display_defaults.copy()
	else:
            self.displays=displays
        self.update_data(data, content_type, size)


# What is the performance of the following? I suspect that this one section
# will affect performance more than anything....
    def __call__(self, REQUEST=None, display=None, 
                 pdcookie=None, height=None, 
		 width=None, alt=None, **args):
        """
        Generate an HTML IMG tag for this photo, with customization. 
	The display size will be selected from 
	1. DTML parameter
	2. Users pdcookie
	3. DTML specified width and height (this is dynamicaly generated).
	4. Default to preview
	5. Display original image.
	Other tags may be specified as keyword=value pairs.
        """
	# Check for a display parmameter in DTML
	if display and self.displays.has_key(display):
            (width, height) = self.displays[display]['actual']
	    string ='<img src="%s?display=%s" width="%s" height="%s"' % (
	        self.absolute_url(), display, width, height
		)
	# Check the cookie for the preferred display size
	elif (REQUEST and REQUEST.cookies.has_key('pd') and
	      self.displays.has_key(REQUEST.cookies['pd'])):
            display=REQUEST.cookies['pd']
            (width, height) = self.displays[display]['actual']
	    string ='<img src="%s?display=%s" width="%s" height="%s"' % (
	        self.absolute_url(), display, width, height
		)
        # Check for dynamic size specification in DTML, 
	# this can be SLOW, because the image is PIL'd for every request.
	elif width or height:
	    (width, height) = self._preserveAspectRatio(width, height)
            string='<img src="%s/resize?width=%s&height=%s"' % (
	        self.absolute_url(), width, height
		)
	    string ='%s width="%s" height="%s"' % (
	        string, width, height
		)
	# Default to preview display if no cookie
        elif self.displays.has_key('preview'):
            (width, height) = self.displays['preview']['actual']
	    string ='<img src="%s?display=preview" width="%s" height="%s"' % (
	        self.absolute_url(), width, height
		)
	# Finally, use original image as a last resort
	else:
	    string = '<img src="%s" width="%s" height="%s"' % (
	        self.absolute_url(), self.width, self.height
                )
        # Address remaining attributes
        if alt is None:
            alt=self.title_or_id()
        if alt:
            string = '%s alt="%s"' % (string, alt)
        for key in args.keys():
            value = args.get(key)
            string = '%s %s="%s"' % (string, key, value)
	string = string +'>'
        # Add Cookie Bar
	if pdcookie and REQUEST:
            pd='<table border="0" cellpadding="0" cellspacing="0"><tr>'
	    pd='%s<td align="center" colspan="%s">' % (pd, len(self.displays))
	    pd='%s%s</td></tr><tr>' % (pd, string)
	    for d in self.displayMap():
	        if d['id'] in ('thumbnail','preview'): continue
                pd='%s<td align="center"><small><small><small> ' % (pd)
	        if (REQUEST.cookies.has_key('pd') and 
		    d['id'] == REQUEST.cookies['pd']):
                    pd='%s %s ' % (pd, d['id'])
		else:
                    pd='%s <a href="%s/setcookie?display=%s&redir=%s">' % (
	                pd, self.absolute_url(), d['id'], quote(REQUEST.URL)
                        )
                    pd='%s%s</a> ' % (pd, d['id'])
                pd='%s </small></small></small></td>' % (pd)
            else:
	        pd=pd + '<td></td>'
	    pd='%s</tr></table>' % (pd)
	    string = pd
        return string 

    def displayMap(self):
        """Return a tuple of photo display mappings"""
	displayMap = []
        for display in self.displays.keys():
	    (width, height) = self.displays[display]['target']
	    (actual_width, actual_height) = self.displays[display]['actual']
	    size = self.displays[display]['size']
            displayMap = displayMap +  [{ 'id' : display ,
	                                  'width' : width ,
					  'height' : height ,
	                                  'actual_width' : actual_width ,
					  'actual_height' : actual_height ,
					  'size' : size ,
                                       }]
	displayMap.sort(lambda a,b: cmp(a['size'],b['size']))
	return tuple(displayMap)

    def setcookie(self, display=None, redir=None, REQUEST=None):
        """
	Set a cookie and redirect browser to the requesting page
	"""
	if REQUEST and display:
	    REQUEST.RESPONSE.setCookie('pd',display,path='/')
	if REQUEST and redir:
            REQUEST.RESPONSE.redirect(redir)

    tag=__call__

    def update_data(self, data, content_type = None, size = None):
        """
        Replaces the current contents of the Photo object with file.
        """
        Image.update_data(self, data, content_type, size)
        self._generateDisplays(REQUEST=None)

    def _addDisplay(self, display, width, height):
        """ Add a display for this photo """
        if self.displays.has_key(display):
            raise 'Bad Request', 'Invalid or duplicate display name'
	self.displays[display]= {
	    'actual' : (0,0),
	    'target' : (width,height),
	    'size' : 0}
	self._generateDisplay(display)
 
    def _editDisplay(self, display, width, height):
        """ Modify a display for this photo """
        self.displays[display]['target'] = (width, height)
	self._generateDisplay(display)

    def _delDisplay(self, display):
        """ Delete a display from this photo """
        delattr(self, 'data_' + display)
	displays = self.displays
	del displays[display]
	self.displays = displays

    def _generateDisplays(self, REQUEST=None):
        """ Recreate all of the display sizes for this photo """
	if self._validImage():
            for display in self.displays.keys():
                (width, height) = self.displays[display]['target']
                self._generateDisplay(display)
        if REQUEST:
            REQUEST['RESPONSE'].redirect(self.absolute_url()+'/manage_displays')

    def _generateDisplay(self, display):
        """ Recreate one display for a Photo """
	if not self._validImage():
	    return None
	(width, height) = self.displays[display]['target']
        (width, height) = self._preserveAspectRatio(width, height)
	setattr(self, 'data_' + display, self.resize(width, height))
        self.displays[display]['actual'] = (width, height)
	self.displays[display]['size'] = len(getattr(self, 'data_' + display))

    def _preserveAspectRatio(self, width, height):
        """ 
	Return largest width and height while preserving the aspect ratio 
	"""
        original_width=int(self.width)
        original_height=int(self.height)
	if width: width=int(width)
	if height: height=int(height)
	if not self._validImage():
            width = None
            height = None
        elif height is None or ( width and 
	      (height > original_height * width / original_width)):
            height = original_height * width / original_width
        else:
            width =  original_width * height / original_height
        return(width, height)

    def resize(self, width=None, height=None, REQUEST = None):
        """Return a scaled image"""
        if not self._validImage():
            return None
        # Unwrap PData if size bigger than 1<<16
	if type(self.data) == StringType:
            im = PIL.Image.open(StringIO(self.data))
	else:
            r = [self.data.data]
            next = self.data.next
            while next is not None:
	        self=next
                r.append(self.data)
		next=self.next
            r = string.join(r,'')
            im = PIL.Image.open(StringIO(r))
	fmt = im.format
	if fmt == 'PNG':
	  fmt = 'JPEG'
        im = im.resize((int(width),int(height)))
# Experiment with Sharpen, probably needs to be user defined. apl 20000131
#        im = PIL.ImageEnhance.Sharpness(im)
#        im = im.enhance(1.3)
        outFile = StringIO()
        im.save(outFile, fmt)
        outFile.seek(0)
        outString = outFile.read()
	# Set Response Headers if HTTP request
        if REQUEST:
            REQUEST.RESPONSE.setHeader('Last-Modified', rfc1123_date(self._p_mtime))
            REQUEST.RESPONSE.setHeader('Content-Type', self.content_type)
        return outString

    def _validImage(self):
        if (    (self.size >0) 
            and (self.width != "" and self.height != "")
            and (self.width is not None and self.height is not None)
           ):
           return 1
        else:
           return 0
# Yes. I know it is bad form to leave commented-out code behind. But this won't
# be here long. I promise. The problem is that this is mostly baked, but not 
# fully.
#
# self.Double__shame__ = on
#
#    def transpose(self, method=None, REQUEST = None):
#        """Return a flipped or rotated image"""
#        if (self.size <= 0) or (method in (None,
#            FLIP_LEFT_RIGHT, FLIP_TOP_BOTTOM, ROTATE_90, ROTATE_180, ROTATE_270)):
#            return None
#        im = self._imageData()
#        fmt = im.format
#        im = im.transpose(method)
#        outFile = StringIO()
#        im.save(outFile, fmt)
#        outFile.seek(0)
#        outString = outFile.read()
#        # Set Response Headers if HTTP request
#        if REQUEST:
#            REQUEST.RESPONSE.setHeader('Last-Modified', rfc1123_date(self._p_mtime))
#            REQUEST.RESPONSE.setHeader('Content-Type', self.content_type)
#        return outString
#
#    def resize(self, width=None, height=None, method=BICUBIC, REQUEST = None):
#        """Return a scaled image"""
#        if ( (self.size <= 0) or
#             (height is None or width is None) or
#             (method not in (NEAREST, BILINEAR, BICUBIC) ) ):
#            return None
#        im = self._imageData()
#        fmt = im.format
#        # Convert to int just incase this is called from the web directly
#        im = im.resize((int(width),int(height)), method)
#        outFile = StringIO()
#        im.save(outFile, fmt)
#        outFile.seek(0)
#        outString = outFile.read()
#        # Set Response Headers if HTTP request
#        if REQUEST:
#            REQUEST.RESPONSE.setHeader('Last-Modified', rfc1123_date(self._p_mtime))
#            REQUEST.RESPONSE.setHeader('Content-Type', self.content_type)
#        return outString
#
#    def _imageData(self):
#        """Open and return an PIL Image using Zope Image data"""
#        # Unwrap PData if size bigger than 1<<16
#        if type(self.data) == StringType:
#            return PIL.Image.open(StringIO(self.data))
#        else:
#            r = [self.data.data]
#            next = self.data.next
#            while next is not None:
#                self=next
#                r.append(self.data)
#                next=self.next
#            r = string.join(r,'')
#            return PIL.Image.open(StringIO(r))
#
##   Web Interface
#    def manage_resizeImage(self, REQUEST = None):
#        """ Resize base Image through the web"""
#        width = REQUEST.get('width')
#        width = int(width)
#        if width is None:
#            raise 'BadRequest', 'The width does not exist.'
#        height = REQUEST.get('height')
#        height = int(height)
#        if height is None:
#            raise 'BadRequest', 'The height does not exist.'
#        method = REQUEST.get('method')
#        if method is None:
#            method = BICUBIC
#        self.data = self.resize(height, width, method)
#        self._generateDisplays()
#        return MessageDialog(
#               title  ='Success!',
#               message='Your changes have been saved',
#               action ='manage_displays')
#
#    def manage_transposeImage(self, REQUEST = None):
#        """ Transpose base Image through the web """
#        method = REQUEST.get('method')
#        if method not in (NEAREST, BILINEAR, BICUBIC):
#            raise 'BadRequest', 'The specified transpose method is not defined'
#        self.data = self.transpose(method)
#        self._generateDisplays()
#        return MessageDialog(
#               title  ='Success!',
#               message='Your changes have been saved',
#               action ='manage_displays')
#
# self.Double__shame__ = off
# End partially baked section

#   Web Interface
    def manage_editDisplay(self, REQUEST = None):
        """ Edit displays through the web"""
        for display in self.displays.keys():
	    width = REQUEST.get('width-' + display)
	    width = int(width)
	    height = REQUEST.get('height-' + display)
	    height = int(height)
            self._editDisplay(display, width, height)
        return MessageDialog(
               title  ='Success!',
               message='Your changes have been saved',
               action ='manage_displays')
	
    def manage_addDisplay(self, id, width, height, REQUEST = None):
        """ Add a display through the web"""
	display = REQUEST.get('id')
        if display is None:
	    raise 'BadRequest', 'The display name does not exist.'
	width = REQUEST.get('width')
        width = int(width)
	if width is None:
	    raise 'BadRequest', 'The display width does not exist.'
	height = REQUEST.get('height')
        height = int(height)
        if display is None:
	    raise 'BadRequest', 'The display height does not exist.'
        self._addDisplay(display, width, height)
        if REQUEST:
            REQUEST['RESPONSE'].redirect(self.absolute_url()+'/manage_displays')
	
    def manage_delDisplay(self, ids, REQUEST = None):
        """ Delete one or more displays through the web"""
        if ids is None:
            return MessageDialog(
                   title='No displays specified',
                   message='No diplsays were selected for deletion!',
                   action ='./manage_displays',)
        for id in ids:
            if not self.displays.has_key(id):
                raise 'BadRequest', (
                      'The display <em>%s</em> does not exist' % id)
	    self._delDisplay(id)

        if REQUEST:
            return self.manage_displays(self, REQUEST)

    def index_html(self, REQUEST, RESPONSE, display = None ):
        """
        The default view of the contents of the Photo
        Returns the contents of the Photo at the requested display size.
	Also, sets the Content-Type HTTP header to the objects content type.
        """
        if (not display and 
            REQUEST and REQUEST.cookies.has_key('pd') and
	      self.displays.has_key(REQUEST.cookies['pd'])):
           display=REQUEST.cookies['pd']
        if display and self.displays.has_key(display):
            # Attempt to handle If-Modified-Since headers.
            ms=REQUEST.get_header('If-Modified-Since', None)
            if ms is not None:
                ms=string.split(ms, ';')[0]
                ms=DateTime(ms).timeTime()
                if self._p_mtime > ms:
                    RESPONSE.setStatus(304)
                    return RESPONSE
            # Set the response header for the photo
            RESPONSE.setHeader('Last-Modified', rfc1123_date(self._p_mtime))
            RESPONSE.setHeader('Content-Type', self.content_type)
	    return getattr(self, 'data_' + display)
        else:
	    # Inherit the Image behavior
            return Image.index_html(self, REQUEST, RESPONSE)

def manage_addZPhotoAlbum(self, id, title, REQUEST=None):
    """Add a ZPhotoAlbum object"""
    topic = ZPhotoAlbum(id, title)
    self._setObject(id, topic)
    if REQUEST is not None:
        return self.manage_main(self, REQUEST)

class ZPhotoAlbum(ZCatalog.ZCatalog):
    """PhotoAlbum object"""
    meta_type = 'ZPhotoAlbum'
    _properties=({'id':'title',        'type':'string'},
                 {'id':'caption',      'type':'string'},
                 {'id':'keywords',     'type':'lines'},
                 {'id':'description',  'type':'text'},
                 )
    manage_displays=HTMLFile('displays',globals())
    manage_options=( 
        {'label': 'Contents', 'action': 'manage_main', 'target': 'manage_main'},
        {'label': 'Default Displays', 'action': 'manage_displays', 'target': 'manage_main'},
        {'label': 'Cataloged Objects', 'action': 'manage_catalogView', 'target': 'manage_main'},
        {'label': 'MetaData Table', 'action': 'manage_catalogSchema', 'target':'manage_main'},
        {'label': 'Indexes', 'action': 'manage_catalogIndexes', 'target':'manage_main'},
        {'label': 'Status', 'action': 'manage_catalogStatus', 'target':'manage_main'},
        {'label': 'Displays', 'action': 'manage_displays', 'target':'manage_main'},
        )

    def __init__(self, id, title='', description='', keywords='', caption=''):
        # Initialise ZCatalog
        ZCatalog.ZCatalog.__init__(self, id, title)
        self.description=description
        self.keywords=keywords
        self.caption=caption
        self.displays=display_defaults.copy()
        # Set up the indexes
        self._catalog.addIndex('description','TextIndex')
        self._catalog.addIndex('subject','TextIndex')
        self._catalog.addIndex('photographer','FieldIndex')
        self._catalog.addIndex('datestamp','FieldIndex')
        self._catalog.addIndex('coolness','FieldIndex')
        self._catalog.addIndex('keywords','FieldIndex')
        self._catalog.addIndex('caption','TextIndex')
        self._catalog.addIndex('tech_details','TextIndex')
        self._catalog.addIndex('created','FieldIndex')
        self._catalog.addIndex('modifed','FieldIndex')
        # Set up meta-data columns
        self._catalog.addColumn('description')
        self._catalog.addColumn('subject')
        self._catalog.addColumn('photographer')
        self._catalog.addColumn('datestamp')
        self._catalog.addColumn('coolness')
        self._catalog.addColumn('keywords')
        self._catalog.addColumn('caption')
        self._catalog.addColumn('tech_details')
        self._catalog.addColumn('created')
        self._catalog.addColumn('modifed')

    # Handy utility to join together searchs against various attributes.
    def searchJoin(self, *args):
        results = []
        for list in args:
            for item in list:
                if not item in results:
                    results.append(item)
        return results

    #Add, Edit and Delete Default Displays through the web
    def displayMap(self):
        """Return a tuple of photo mappings"""
	displayMap = []
        for display in self.displays.keys():
	    (width, height) = self.displays[display]['target']
	    (actual_width, actual_height) = self.displays[display]['actual']
	    size = self.displays[display]['size']
            displayMap = displayMap +  [{  'id' : display
	                                 , 'width' : width
					 , 'height' : height
	                                 , 'actual_width' : actual_width
					 , 'actual_height' : actual_height
					 , 'size' : size}]
	displayMap.sort(lambda a,b: cmp(a['width'],b['width']))
	return tuple(displayMap)

    def _addDisplay(self, display, width, height):
        """ Add a display for this photo """
        if self.displays.has_key(display):
            raise 'Bad Request', 'Invalid or duplicate display name'
	self.displays[display]= {
	    'actual' : (0,0),
	    'target' : (width,height),
	    'size' : 0}
 
    def _editDisplay(self, display, width, height):
        """ Modify a display for this photo """
        self.displays[display]['target'] = (width, height)

    def _delDisplay(self, display):
        """ Delete a display from this photo """
	displays = self.displays
	del displays[display]
	self.displays = displays

    manage_addDisplay  = Photo.manage_addDisplay
    manage_editDisplay = Photo.manage_editDisplay
    manage_delDisplay  = Photo.manage_delDisplay

#    def manage_editZPhotoAlbum(self, title, REQUEST=None):
#        """Modify properties of ZPhotoAlbum"""
#        self.title = title
#        self.description=description
#        self.keywords=keywords
#        self.caption=caption
#        if REQUEST:
#            return self.manage_main(self, REQUEST, manage_tabs_message = "ZPhotoAlbum changed.")


class ZAlbumPage(PropertyManager, RoleManager, FindSupport, CatalogAware):

    """AlbumPage object"""
    meta_type = 'ZAlbumPage'
    _properties=({'id':'title',        'type':'string'},
                 {'id':'caption',      'type':'string'},
                 {'id':'keywords',     'type':'lines'},
                 {'id':'description',  'type':'text'},
                 )
    manage_options=( 
        {'label': 'Contents', 'action': 'manage_main', 'target': 'manage_main'},
        {'label': 'Add ZAlbumPage', 'action': 'ZAlbumPage_addForm', 'target': 'manage_main'},
        {'label': 'Add ZPhoto', 'action': 'ZPhoto_addForm', 'target': 'manage_main'},
        {'label': 'View', 'action': 'index_html', 'target': 'manage_main'},
        {'label': 'Properties', 'action': 'manage_propertiesForm', 'target': 'manage_main'},
        )
 
    def __init__(self, id, title = '', description = '', caption = '', keywords = ''):
        self.id = id
        self.title = title
        self.description = description
        self.caption = caption
        self.keywords = keywords
 
# We call this method from the management interface to allow ZAlbumPages
# to contain other ZAlbumPages as subobjects
    def manage_addZAlbumPage(self, id, REQUEST = None):
        """Add a ZAlbumPage to this ZPhotoAlbum"""
	if (REQUEST):
	    if (REQUEST.has_key('title')):
	        title = REQUEST['title']
	    if (REQUEST.has_key('description')):
	        description = REQUEST['description']
	    if (REQUEST.has_key('caption')):
	        caption = REQUEST['caption']
	    if (REQUEST.has_key('keywords')):
	        keywords = REQUEST['keywords']
# The __class__ trickery is thanks to Jim Fulton, I suspect this is part
# of extension classes.
        item = self.__class__(id, title = title, description = description, 
	                      caption = caption, keywords = keywords)
        self._setObject(id, item)
        if REQUEST is not None:
            return self.manage_main(self, REQUEST)


class ZPhoto(Photo, CatalogAware):
    """
    Photo objects are images. Each Photo will save itself at a variety
    of display sizes for fast and easy retrieval from the web.
    """
    meta_type='ZPhoto'
    _properties=({'id':'title',        'type':'string'},
                 {'id':'caption',      'type':'string'},
                 {'id':'subject',      'type':'string'},
                 {'id':'photographer', 'type':'string'},
                 {'id':'tech_details', 'type':'string'},
                 {'id':'datestamp',    'type':'date'},
                 {'id':'coolness',     'type':'string'},
                 {'id':'copyright',    'type':'string'},
                 {'id':'keywords',     'type':'lines'},
                 {'id':'description',  'type':'text'},
                 {'id':'content_type', 'type':'string'},
                 {'id':'height',       'type':'string'},
                 {'id':'width',        'type':'string'}
                 )

    def __init__(self, id, title, file, 
                 description = '', subject = '', photographer = '', datestamp = '', coolness = '',
                 keywords = '', caption = '', tech_details = '', copyright = '',
                 displays = None, content_type = '', precondition = ''):
        Photo.__init__(self, id, title, file, displays, content_type, precondition)
        self.description=description
        self.subject=subject
        self.photographer=photographer
        self.datestamp=datestamp
        self.coolness=coolness
        self.keywords=keywords
        self.caption=caption
        self.tech_details=tech_details
        self.copyright=copyright

