#-*- mode: python; mode: fold -*-
#
#       $Id: Calendar.py,v 1.2 2003/03/20 19:10:44 perry Exp $ #{{{
#
##Copyright (c) 2002 AixtraWare All rights reserved. 
##
##Redistribution and use in source and binary forms, with or without
##modification, are permitted provided that the following conditions
##are met:
##
##1. Redistributions of source code must retain the above copyright
##   notice, this list of conditions and the following disclaimer.
##
##2. Redistributions in binary form must reproduce the above copyright
##   notice, this list of conditions and the following disclaimer in the
##   documentation and/or other materials provided with the distribution.
##
##3. Neither the name of AixtraWare or the names of its contributors  may 
##   be used to endorse or promote products derived from this software 
##   without specific prior written permission
##
##THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
##"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
##LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
##A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INFRAE OR
##CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
##EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
##PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
##PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
##LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
##NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
##SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

__doc__="""$Id: Calendar.py,v 1.2 2003/03/20 19:10:44 perry Exp $"""

#}}}

from CalendarInterface import CalendarInterface
from AccessControl import ClassSecurityInfo, getSecurityManager
from Globals import InitializeClass, DTMLFile
from DocumentTemplate import sequence
import Globals
from Acquisition import Implicit
from Globals import Persistent
from AccessControl.Role import RoleManager
from OFS.SimpleItem import SimpleItem
from OFS.Folder import Folder
from Products.PythonScripts.PythonScript import manage_addPythonScript
from Products.PageTemplates.ZopePageTemplate import manage_addPageTemplate
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Products.AixtraTable.AixtraTableProduct import AixtraTable
from Products.AixtraTable.AixtraTableProduct import parseDescription
from string import *
import time
import re,sys,os
from DateTime import DateTime
from zLOG import LOG, ERROR, WARNING

file_path = Globals.package_home(globals())

def dblog(s,*args,**y): #{{{
    try:
	raise 'dummy'
    except:
	frame = sys.exc_traceback.tb_frame.f_back
	locals = frame.f_locals
	globals = frame.f_globals
	functionname = frame.f_code.co_name
	filename = os.path.basename(frame.f_code.co_filename)
	lineno = frame.f_lineno
    s.append('>>> in file: %s; function: %s; line: %d\n' % (filename,
	           functionname, lineno))
    for i in range(len(args)):
	s.append('arg #%d = %s\n' % (i, args[i]))
    for i in y.keys():
	s.append('%s = %s\n' % (i, y[i]))
    return s

#}}}

addForm=PageTemplateFile('zpt/addForm', globals())

vcalendarDescription = """#{{{
=calscale
typ string
#
=x-wr-timezone
typ string
#
=x-wr-caldesc
typ string
#
=prodid
typ string
#
=x-wr-calname
typ string
#
=x-wr-relcalid
typ string
#
=version
typ string
"""
#}}}
veventDescription = """#{{{ 
#
=uid
typ string
lab unique id
help unique id
#
=alarmc_id
typ string
lab alarm
help alarm id
#
=class
typ string
lab class
help class
#
=created
typ datetime
lab created
#
=dtstart
typ datetime
index
lab Start
help Start DateTime
#
=dtend
typ datetime
index
lab End
help End DateTime
#
=duration
typ string
lab duration
help duration
#
=description
typ text
index
lab description
help description
row 5
col 60
#
=last-mod
typ datetime
lab last modified
help last modified
#
=location
typ string
lab location
help location
#
=organizer
typ email
lab organizer
help organizer email
#
=priority
typ int
lab priority
help priority
#
=dtstamp
typ datetime
lab timestamp
help timestamp
#
=seq
typ int
lab sequence
help sequence
#
=status
typ string
lab status
help status
#
=summary
typ text
lab summary
help summary
col 60
row 2
#
=transp
typ boolean
#
=url
typ string
#
=rstatus
typ string
#
=recurid
typ string
#
=rrule
typ string
lab repeatrule
#
=attach
typ text
row 3
col 60
#
=attendee
typ email
=categories
typ string
#
=comment
typ text
#
=contact
typ email
#
=exdate
typ date
#
=exrule
typ string
#
=related
typ string
#
=resources
typ text
#
=rdate
typ date
#
=x-prop
typ text
"""
#}}}
vjournalDescription = """#{{{
session_data_manager
#
=class
typ string
#
=created
typ datetime
#
=description
typ text
#
=dtstamp
typ datetime
#
=dtstart
typ datetime
#
=last-mod
typ datetime
#
=organizer
typ email
#
=recurid
typ string
#
=seq
typ int
#
=status
typ string
#
=summary
typ text
#
=uid
typ string
#
=url
typ string
#
=attach
typ text
#
=attendee
typ email
#
=categories
typ string
#
=comment
typ text
#
=contact
typ email
#
=recurid
typ string
#
=rstatus
typ string
#
=related
typ string
#
=x-prop
typ text
"""
#}}}
vtodoDescription = """#{{{
session_data_manager
#
=class
typ string
#
=completed
typ datetime
#
=created
typ datetime
#
=description
typ text
#
=dtstamp
typ datetime
#
=dtstart
typ datetime
#
=last-mod
typ datetime
#
=location
typ string
#
=organizer
typ email
#
=percent
typ int
#
=priority
typ int
#
=recurid
typ string
#
=seq
typ int
#
=status
typ string
#
=summary
typ text
#
=uid
typ string
#
=url
typ string
#
=due
typ datetime
#
=duration
typ string
#
=attach
typ text
#
=attendee
typ email
#
=categories
typ string
#
=comment
typ text
#
=contact
typ email
#
=recurid
typ string
#
=rstatus
typ string
#
=related
typ string
#
=resources
typ string
#
=x-prop
typ text
"""
#}}}
vfreebusyDescription = """#{{{
session_data_manager
#
=contact
typ email
#
=dtstart
typ datetime
#
=dtend
typ datetime
#
=duration
typ string
#
=dtstamp
typ datetime
#
=organizer
typ email
#
=uid
typ string
#
=url
typ string
#
=attendee
typ email
#
=comment
typ text
#
=freebusy
typ string
#
=rstatus
typ string
#
=x-prop
"""
#}}}

def readDate(s): #{{{
    try:
	d,t = s.split('T')
    except:
	d = s
	t = None
    year = d[:4]
    month = d[4:6]
    day = d[6:8]
    if t:
	if t.endswith('Z'):
	    t = t[:-1]
	hour = t[:2]
	min  = t[2:4]
	if len(t) > 4:
	    sec = t[4:6]
	else:
	    sec = "00"
    else:
	hour = min = sec = "00"
    ds = "%(year)s/%(month)s/%(day)s %(hour)s:%(min)s:%(sec)s" % vars()
    #return ds
    date = DateTime(ds)
    return date
	    
#}}}

def lastday(month): #{{{
    m = int(month)
    ld = ["0","31",(DateTime().isLeapYear() and "29") or "28","31","30","31","30","31","31","30","31","30","31"]
    return ld[m]
#}}}

storages = {#'VCALENDAR': 'vcalendar', #{{{
            'VEVENT': 'vevent',     
            'VJOURNAL' : 'vjournal',
	    'VTODO' : 'vtodo',
	    'VFREEBUSY' : 'vfreebusy',
	    }

def readIcal(self, lines, update=0): 
    store = {}
    item = None
    vobjStack = []
    propsStack = []
    l = 0
    while l < len(lines):
	data = lines[l]
	n = l + 1
	while n < len(lines)-1 and lines[n][0] == " ":
	    data = data.rstrip() + lines[n]
	    n += 1
	l = n - 1
        # VCALENDAR, VEVENT or VTODO
        m = re.search('^[ \t]*BEGIN:[ \t]*(\S*)',data)
        if m :
            vobjname = m.group(1)
	    vobjStack.append(vobjname)
	    if vobjname == "VCALENDAR":
		store[vobjname] = self
	    elif vobjname in storages.keys():
		store[vobjname] = getattr(self,storages[vobjname])
	    else:
		return "No valid Storage"
	    propsStack.append({})
        else :
            m = re.search('^[ \t]*END:[ \t]*(\S*)',data)
            if m :
                vobjname = m.group(1)
		vobjopen = vobjStack.pop()
		props = propsStack.pop()
		if store.has_key(vobjname):
    	    	    if props and vobjname != "VCALENDAR":
	    	    	if props.has_key('uid'):
	    	    	    item=store[vobjname].getItem(props['uid'])
			    #LOG('Calendar readIcal', WARNING, "old Item: %s" % props['uid'])
			if not item:
	    	    	    item=store[vobjname].newItem(props['uid'])
			    #LOG('Calendar readIcal', WARNING, "new Item: %s" % props['uid'])
	    	    	else:
	    	    	    if not store[vobjname]:
				pass
			if item:
			    for k in props.keys():
		    	    	t = store[vobjname].FieldDict[k]['type']
				v = props[k]
		    	    	if t in ("date","datetime","time"):
			    	    props[k] = readDate(v)
		    	    	elif t in ("int",):
			    	    props[k] = int(v)
			    apply(self.vevent.setItemAttrs, (item.id,), props)
			    #LOG('Calendar readIcal', WARNING, "props: %s" % (props))
    	    	    elif not update and props and vobjname == "VCALENDAR":
			self.calendarProps = props
		    del store[vobjname]
            else :
                # VCF property 'propname;paramname=paramvalue:propvalue'
                m = re.search('^[ \t]*([^\s;:]*);?([^:]*):(.*)',data)
                if m :
		    props = propsStack[-1]
                    propname = m.group(1)
                    proptype = m.group(2)
                    propvalue = m.group(3)
		    #LOG('Calendar readIcal', WARNING, "ppp: %s : %s type: %s" % (propname,proptype,propvalue))
		    props[propname.lower()] = propvalue.strip()
                    if m.group(2) != '' :
                        propparams = re.split(';',m.group(2))
                        for i in propparams :
                            try:
                                (paramname,paramvalue) = re.split('=',i)
                            except:
                                print "Warning : bad format"
                                paramname = "Unknown"
                                paramvalue = "Unkown"
                    # 'X-' prefixed properties
                    if re.match('X-',propname) :
                        propname = 'extension'
	l += 1
    return
#}}}

# writeIcalEvent  #{{{


def icalStart(self):
    l = []
    l.append("BEGIN:VCALENDAR")
    for a in self.calendarProps.keys():
	value = self.calendarProps[a]
	if value:
	    l.append("%s\n  :%s" % (a.upper(), value))
	else:
	    l.append("%s\n  :%s" % (a.upper(), "no value"))
    return l
	
icalEnd = """END:VCALENDAR"""

eventBegin = """BEGIN:VEVENT"""
eventEnd = """END:VEVENT"""

def writeIcalEvent(self,event):
    l = []
    l.append(eventBegin)
    for a in self.vevent.FieldList:
	value = getattr(event,a,None)
	if event.FieldDict[a]["type"] == "datetime" and value:
	    value = value.strftime("%Y%m%dT%H%M%SZ")
	if value:
	    l.append("%s\n  :%s" % (a.upper(), value))
##	else:
##	    l.append("%s\n  :%s" % (a.upper(), "no value"))
    l.append(eventEnd)
    return l

#}}}

def addFunction(dispatcher, id, title, file, REQUEST=None): #{{{
    """
    Create a new Calendar and add it to the destination.
    """
    get =  REQUEST.get
    set =  REQUEST.set
    if get("file").filename != "":
	lines = get('file').read().split('\n')
    else:
	lines = get('txt').split('\n')
    p=Calendar(id, title, lines,)
    dispatcher.Destination()._setObject(id, p)
    if REQUEST is not None:
        dispatcher.manage_main(dispatcher, REQUEST)

#}}}

class Calendar(Folder): #{{{
    """
    Calendar product class, implements CalendarInterface.
    """
    __implements__ = CalendarInterface

    meta_type='Calendar'

    mo = (
        {'label' : 'Calendar',
         'action' : 'editCalendarForm',
         'help' : ('Calendar', 'edit.txt')
         },
        {'label' : 'Events',
         'action' : 'listEventsForm',
         },
        )

    manage_options = mo + Folder.manage_options
    
    security=ClassSecurityInfo()
    #}}}

    def __init__(self, id, title, lines, languages=None): #{{{
	self.id = id
	self.title = title
	#parseDescription(self,calendarDescription)
	languages = ("de",)
        #self.vcalendar = AixtraTable("vcalendar",languages,description=vcalendarDescription)
        self.vevent = AixtraTable("vevent",languages,description=veventDescription)
        self.vjournal = AixtraTable("vjournal",languages,description=vjournalDescription)
        self.vtodo = AixtraTable("vtodo",languages,description=vtodoDescription)
        self.vfreebusy = AixtraTable("vfreebusy",languages,description=vfreebusyDescription)
	if lines:
	    readIcal(self,lines)
	    self.vevent.reindex()
	return 
    #}}}
    
    security.declareProtected('Change Calendar', 'editCalendar')
    editCalendarForm=PageTemplateFile('zpt/editForm', globals())
    def editCalendar(self, title, REQUEST=None): #{{{
        """Edits the Calendar"""
	self.title = title
	if not REQUEST is None:  
	    return self.editCalendarForm(REQUEST,
				manage_tabs_message='Calendar changed.')
    #}}}
    editEventForm=PageTemplateFile('zpt/editEventForm', globals())
    def editEvent(self, title, REQUEST=None): #{{{
        """Edits the Calendar"""
	self.title = title
	if not REQUEST is None:  
	    return self.editEventForm(REQUEST,
				manage_tabs_message='Calendar changed.')
    #}}}
    
    def deleteEventList(self,REQUEST): #{{{
	"""delets events in ids"""
	has = REQUEST.has_key
	get =  REQUEST.get
	if has("ids") and get("ids"):
	    for id in get("ids"):
		self.vevent.removeItem(id)
	return self.listEventsForm(REQUEST)
    #}}}
	
    def dumpIcal(self): #{{{
	"returns the events as Ical"
    	l = []
    	l.extend(icalStart(self))
	l.append("Calendar contains %d events" % len(self.vevent._items.keys()))
    	l.append(icalEnd)
    	return "\n".join(l)
    #}}}

    def dumpIcalEvents(self,REQUEST): #{{{
	"returns the events as Ical"
	has = REQUEST.has_key
	get =  REQUEST.get
	set =  REQUEST.set
	method = get("REQUEST_METHOD")
	month = get("month",0)
	if month:
	    today = DateTime()
	    start = DateTime("%s/%s/01" % (today.year(),month))
	    end = DateTime("%s/%s/%s" % (today.year(),month,lastday(month)))
	    events = self.vevent(dtstart={'query' : (start, end),
                                          'range' : 'minmax'
                                          })
	else:
	    events = self.vevent()
	if method =="GET":
    	    l = []
    	    l.extend(icalStart(self))
    	    for e in events:
	    	event = self.vevent.getItem(e.id)
##		if month and event.dtstart.mm() == month:
		l.extend(writeIcalEvent(self,event))
    	    l.append(icalEnd)
	    return "\n".join(l)
	if method =="PUT":
	    body = get('BODY', '')
	    lines = body.split("\n")
	    readIcal(self,lines,update=1)
	    #LOG('Calendar PUT', WARNING, "BODY: %s" % body)
    #}}}
    index_html = dumpIcalEvents

    def getSortedEvents(self,sort="uid",reverse=0): #{{{
	"""returns a list of sorted events"""
    	R = self.vevent
    	res=R()
    	    
    	l = []
    	for r in res:
    	    item = R.getItem(r.id)
    	    if item:
	    	l.append(item)
    	
    	# build arguments for sequence.sort
    	if sort=='uid':
    	    if not reverse:
            	args=(('uid',),)
    	    else:
            	args=(('uid', 'cmp', 'desc'),)
    	elif sort=='dtstart':
    	    if not reverse:
            	args=(('dtstart',), ('uid',))
    	    else:
            	args=(('dtstart', 'cmp', 'desc'), ('uid',))
    	
    	return sequence.sort(l, args)
    #}}}

    def getLink(self, new_sort, sort,reverse): #{{{
	"""get a link"""
    	url=self.REQUEST.URL0
    	if new_sort != sort:
    	    new_reverse=0
    	else:
    	    new_reverse=not reverse
    	return "%s?sort=%s&reverse:int=%s" % (url, new_sort, new_reverse)
    #}}}

    listEventsForm=PageTemplateFile('zpt/listEventsForm', globals())
    def listEvents(self, title, REQUEST=None): #{{{
        """Edits the Calendar"""
	self.title = title
	if REQUEST is not None:  
	    return self.listEventsForm(REQUEST)
    #}}}
    
    def reindexEvents(self, REQUEST=None):  #{{{
        """reindexes the events"""
	self.vevent.reindex()
	if REQUEST is not None:  
	    return self.listEventsForm( REQUEST,manage_tabs_message='Events reindexed')
    #}}}
	

# Initialize product class
# ------------------------

InitializeClass(CalendarInterface)
