#
# Copyright 2001, 2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import Plugin, MatcherBase, ExternalConverterBase, ConversionError, checkCmd
import os, tempfile, re, cgi, misc

try:
  from zLOG import LOG, DEBUG
except ImportError:
  # When called by tests.
  def LOG(*args, **kw):
    pass
  DEBUG = None

checkCmd('pdftotext')

class PDFMatcher(MatcherBase):
  acceptable_mime_types = [
    'application/pdf',
    'text/pdf',
    ]
  acceptable_file_types = [
    'PDF document.*',
    ]
  acceptable_suffixes = [
    'pdf',
    ]

class PDFConverter(ExternalConverterBase):
  suffix = 'pdf'
  mime_type = 'application/pdf'

  def _convert(self):
    self._convertToText()

  def _convertToText(self):
    cmd = ("cd '%s' && pdftotext -raw '%s.pdf' '%s.txt' >'%s.log-pdf' 2>&1" %
           (self.tmpdir,
            self.basefilename, self.basefilename, self.basefilename))
    self._runCommand(cmd, 'pdf', timeout=60)

  def getHtml(self):
    return '<pre>\n%s\n</pre>\n' % cgi.escape(self.getText())


def getPlugins():
  return [
    Plugin('PDF', PDFMatcher, PDFConverter),
    ]

# vim:ts=2
