#
# Copyright 2001, 2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import Plugin, MatcherBase, ExternalConverterBase, checkCmd
import os

checkCmd('unrtf')

class RTFMatcher(MatcherBase):
  acceptable_mime_types = [
    'application/rtf',
    'text/rtf',
    ]
  acceptable_file_types = [
    'Rich Text Format data.*',
    ]
  acceptable_suffixes = [
    'rtf',
    ]

class RTFConverter(ExternalConverterBase):
  suffix = 'rtf'
  mime_type = 'application/rtf'

  def _convertToHtml(self):
    cmd = ("cd '%s' && unrtf '%s.rtf' >'%s.html' 2>'%s.log-rtf'"
           % (self.tmpdir,
              self.basefilename, self.basefilename, self.basefilename))
    self._runCommand(cmd, 'rtf')


def getPlugins():
  return [
    Plugin('RTF', RTFMatcher, RTFConverter),
    ]
