#
# Copyright 2001, 2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#

#
# Register plugins
# 
# XXX: there should be some way to scan the plugins/ directory for plugins
# without explicitly listing them here.

import traceback, os, tempfile, re
from plugin import ConversionError # reexported
from StringIO import StringIO

try:
  from zLOG import LOG, DEBUG, ERROR
except ImportError:
  # When called by tests.
  DEBUG = 0
  ERROR = 1
  def LOG(m, s, *args, **kw):
    if s == ERROR:
      print '%s, ERROR, %s %s' % (m, str(args), str(kw))

_plugin_names = [
  'MSOffice', 'OpenOffice', 'PDF', 'RTF', 'HTML', 'Text',
  'Dumb', # must always be last
  ]

class _PluginSelector:
  def __init__(self, plugin_names):
    self.plugins = []
    for name in plugin_names:
      self.loadPluginModule(name)

  def loadPluginModule(self, name):
    try:
      module = __import__(name, globals(), globals(), [])
      self.plugins.extend(module.getPlugins())
    except:
      f = StringIO()
      traceback.print_exc(file=f)
      LOG('NuxDocument', ERROR, "Error loading plugin %s\n%s" %
          (name, f.getvalue()))

  def getDefaultPlugin(self):
    return self.plugins[-1]

  def getPluginByName(self, name):
    for plugin in self.plugins:
      if plugin.getName() == name:
        return plugin
    raise KeyError, name

  def selectPlugin(self, data, mime_type=None, filename=None):
    tempname = tempfile.mktemp()
    try:
      open(tempname, 'wc').write(data)
      s = os.popen('file -i %s 2>/dev/null' % tempname).read().strip()
      if ':' in s:
        data_mime_type = re.sub('.*: ', '', s)
      else:
        # old version of file
        data_mime_type = re.sub(';.*', '', s)
      s = os.popen('file %s 2>/dev/null' % tempname).read().strip()
      if ':' in s:
        data_file_type = re.sub('.*: ', '', s)
      else:
        data_file_type = s
    finally:
      os.unlink(tempname)

    for plugin in self.plugins:
      matcher = plugin.getMatcher()
      if matcher.matches(data=data,
                         mime_type=mime_type,
                         filename=filename,
                         data_mime_type=data_mime_type,
                         data_file_type=data_file_type):
        return plugin

    return self.getDefaultPlugin()

_plugin_selector = _PluginSelector(_plugin_names)

#
# Only these two functions are exported
#
def selectPlugin(data, mime_type=None, filename=None):
  return _plugin_selector.selectPlugin(data, mime_type, filename)

def getDefaultPlugin():
  return _plugin_selector.getDefaultPlugin()

def getPluginByName(name):
  return _plugin_selector.getPluginByName(name)
