#
# Copyright 2001 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#

import os, time, popen2, signal, re

def systemWithTimeout(cmd, timeout=30, granularity=1):
  """Lauch a command in a subprocess and return the wait exit code."""
  p = popen2.Popen3(cmd)
  count = 0
  status = -1
  while count < timeout:
    time.sleep(granularity)
    count = count + granularity
    status = p.poll()
    if status != -1:
      break
  if status == -1:
    try:
      os.kill(p.pid, signal.SIGKILL)
      status = p.wait()
    except OSError:
      # Process died in the meantime.
      status = 999
  return status


def latin1_to_utf8(s):
  return unicode(s, 'latin-1').encode('utf-8')

latin1_chars = ''.join(map(chr, range(128+32, 256)))
has_utf8 = re.compile('|'.join(map(latin1_to_utf8, latin1_chars))).search
other_utf8 = {
  '\x92': 'OE',
  '\x93': 'oe',
  }

def convert_stray_utf8(s):
  """Convert all stray UTF-8 characters to latin-1.
  """
  if has_utf8(s):
    for c in latin1_chars:
      uc = latin1_to_utf8(c)
      s = s.replace(uc, c)
  for k, v in other_utf8.items():
    s = s.replace(k, v)
  return s
