#!/usr/local/bin/python

import sys, os, unittest
sys.path.insert(0, '..')
sys.path.insert(0, os.environ.get('ZOPE_HOME')+'/lib/python/')
import Zope
import plugins, string

class DocumentTestCase(unittest.TestCase):

  def test_Inert(self):
    doc = plugins.Inert.Inert()
    doc.edit('toto')

    self.assertEquals(doc._data, 'toto')
    self.assertEquals(doc.mime_type, '???/???') # XXX: fix this

  def test_MSWord(self):
    doc = plugins.MSWord.MSWord('test1')
    doc.edit(open('test1.doc').read())
    self.assertEquals(
    	string.count(doc.asHtml(), 'Linux rulez. Window$ SuCk$$$.'), 1)
    self.assertEquals(
    	string.count(doc.asText(), 'Linux rulez. Window$ SuCk$$$.'), 1)

    doc = plugins.MSWord.MSWord('test2')
    doc.edit(open('test2.doc').read())
    self.assertEquals(
    	string.count(doc.asHtml(), 'Linux rulez. Window$ SuCk$$$.'), 1)
    self.assertEquals(
    	string.count(doc.asText(), 'Linux rulez. Window$ SuCk$$$.'), 1)

    doc = plugins.MSWord.MSWord('test3')
    doc.edit(open('test3.doc').read())
    self.assertEquals(
    	string.count(doc.asHtml(), 'Linux rulez. Window$ SuCk$$$.'), 1)
    self.assertEquals(
    	string.count(doc.asText(), 'Linux rulez. Window$ SuCk$$$.'), 1)

    doc = plugins.MSWord.MSWord('test4')
    doc.edit(open('test4.doc').read())
    self.assertEquals(
    	string.count(doc.asHtml(), 'Linux rulez. Window$ SuCk$$$.'), 1)
    self.assertEquals(
    	string.count(doc.asText(), 'Linux rulez. Window$ SuCk$$$.'), 1)
    images = doc.images
    self.assertEquals(len(images), 1)
    self.assertEquals(images.keys()[0], 'test40.png')
    self.assertEquals(len(images['test40.png']), 5690)

if __name__ == '__main__':
  unittest.main()

