#
# Copyright 2001 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
"NuxDocument for the CMF."

from Globals import InitializeClass
from AccessControl import ClassSecurityInfo, getSecurityManager
from Products.CMFCore.PortalContent import PortalContent
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFCore import CMFCorePermissions, utils
from Products.CMFCore.utils import getToolByName
#from Products.CMFCore.WorkflowCore import WorkflowAction, afterCreate
from Products.CMFCore.utils import _format_stx, keywordsplitter
from Products.CMFDefault.utils \
     import parseHeadersBody, SimpleHTMLParser, bodyfinder, _dtmldir

from NuxDocument import NuxDocument

ADD_CONTENT_PERMISSION = 'Add portal content'

factory_type_information = ({
  'id': 'NuxDocument',
  'meta_type': 'CMFNuxDocument',
  'description': """Generic documents.""",
  'icon': 'document_icon.gif',
  'product': 'NuxDocument',
  'factory': 'addCMFNuxDocument',
  'immediate_view': 'metadata_edit_form',
  'actions': (
    {
      'name': 'Download',
      'action': '',
      'permissions': (CMFCorePermissions.View,)
    }, 
    {
      'name': 'View',
      'action': 'NuxDocument_view',
      'permissions': (CMFCorePermissions.View,)
    }, 
    { 
      'name': 'Edit',
      'action': 'NuxDocument_edit_form',
      'permissions': (CMFCorePermissions.ModifyPortalContent,)
    },
    {
      'name': 'Metadata',
      'action': 'metadata_edit_form',
      'permissions': (CMFCorePermissions.ModifyPortalContent,)
    })
},)


def addCMFNuxDocument(self, id, title='', file=''):
    """ Add a NuxDocument """
    o = CMFNuxDocument(id, title=title, file=file)
    self._setObject(id, o)


class CMFNuxDocument(PortalContent, NuxDocument, DefaultDublinCoreImpl):
    "A Document - Handles whatever type is understood by the plugins"

    meta_type = 'CMFNuxDocument'
    effective_date = expiration_date = None
    _isDiscussable = 1

    security = ClassSecurityInfo()

    def __init__(self, id, title='', file=''):
        DefaultDublinCoreImpl.__init__(self)
        NuxDocument.__init__(self, id=id, file=file)

    def _edit(self, title=None, file=None, mime_type=None):
        NuxDocument._edit(self, title, file, mime_type)
        if hasattr(self, 'portal_catalog'): # XXX: do we have a context ? 
            self.reindexObject() # from PortalContent

    security.declareProtected(CMFCorePermissions.ModifyPortalContent, 'edit')
    def edit(self, title, file, mime_type=None):
        NuxDocument._edit(self, title, file, mime_type)
        self.reindexObject() # from PortalContent

    security.declareProtected('View', 'index_html')
    def index_html(self, RESPONSE=None):
        'Default view'
        # XXX: check if and how filename needs to be escaped
        RESPONSE.setHeader('Content-Disposition', "inline; filename=%s"
          % self.filename)
        return self.document_src(RESPONSE=RESPONSE)

    security.declareProtected('View', 'CookedBody')
    def CookedBody(self):
        return bodyfinder(self._html)

    security.declareProtected('View', 'SearchableText')
    def SearchableText(self):
        return NuxDocument.SearchableText(self)

    def _get_icon_name(self):
      # XXX the plugins should provide the icon, refactor later
      mt = self.MimeType()
      icons = {
        'application/pdf':               'icon_pdf.gif',
        'text/msword':                   'icon_doc.gif',
        'application/msword':            'icon_doc.gif',
        'application/vnd.ms-msword':     'icon_doc.gif',
        'application/vnd.ms-powerpoint': 'icon_ppt.gif',
        'application/vnd.ms-excel':      'icon_xls.gif',
        }
      return icons.get(mt, 'document_icon.gif')

    security.declarePublic('getIcon')
    def getIcon(self, relative_to_portal=0):
        """Get the document icon.
        """
        icon = self._get_icon_name()
        if relative_to_portal:
            return icon
        portal_url = getToolByName(self, 'portal_url')
        res = portal_url(relative=1) + '/' + icon
        while res[:1] == '/':
            res = res[1:]
        return res

    security.declarePublic('icon')
    icon = getIcon # For the ZMI


InitializeClass(NuxDocument)
