#
# Copyright 2001-2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import MatcherBase, Plugin, ConversionError, ConverterBase
import os, re, misc


class HTMLMatcher(MatcherBase):
  acceptable_mime_types = [
    'text/html',
    ]
  acceptable_file_types = [
    'HTML document text',
    ]
  acceptable_suffixes = [
    'html',
    'htm',
    ]

class HTMLConverter(ConverterBase):
  suffix = 'html'
  # XXX: mime type should be different for writer/presenter/spread...
  mime_type = 'text/html'

  def getHtml(self):
    return self.data


def getPlugins():
  return [
    Plugin('HTML', HTMLMatcher, HTMLConverter),
    ]
