#
# Copyright 2001-2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import Plugin, MatcherBase, ExternalConverterBase, ConversionError, checkCmd
import os, re, misc

try:
  from zLOG import LOG, DEBUG
except ImportError:
  # When called by tests.
  def LOG(*args, **kw):
    pass
  DEBUG = None

checkCmd('xsltproc')
checkCmd('unzip')

# wv config file (wvZope.xml) is in same directory as this module.
XSL_STYLESHEET = os.path.join(
  os.getcwd(), os.path.dirname(__file__), 'oo2html.xsl')

def debug(s):
  LOG('OpenOffice', DEBUG, s)


class OpenOfficeMatcher(MatcherBase):
  acceptable_mime_types = [
    'application/zip',
    'application/vnd.sun.xml.writer',
    'application/vnd.sun.xml.impress',
    'application/vnd.sun.xml.calc',
    ]
  acceptable_file_types = [
    'Zip archive data, at least v2.0 to extract',
    ]
  acceptable_suffixes = [
    'sxi',
    'sxc',
    'sxw',
    ]

class OpenOfficeConverter(ExternalConverterBase):
  suffix = 'zip'
  # XXX: mime type should be different for writer/presenter/spread...
  mime_type = 'application/unknown'

  def _convertToHtml(self):
    cmd = ("cd '%s' && unzip '%s' >'%s.log-openoffice' 2>&1"
           % (self.tmpdir, self.basefilename, self.basefilename))
    self._runCommand(cmd, 'openoffice')

    try:
      content = open('%s/content.xml' % self.tmpdir).read()
    except IOError:
      debug('content.xml not found')
      raise ConversionError
    if not re.search('DOCTYPE office:document-content PUBLIC', content):
      debug('Bad DOCTYPE')
      raise ConversionError

    cmd = (("cd '%s' && xsltproc --novalid %s content.xml" +
            " >'%s.html' 2>'%s.log-xsltproc'")
           % (self.tmpdir, XSL_STYLESHEET,
              self.basefilename, self.basefilename))
    self._runCommand(cmd, 'xsltproc')

    # XXX: todo: add support for metadata.xml.


def getPlugins():
  return [
    Plugin('OpenOffice', OpenOfficeMatcher, OpenOfficeConverter),
    ]

