#
# Copyright 2001-2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#

"Load ZNuxDocument and, if CMF is present, CMFNuxDocument."

import sys
import ZNuxDocument
from ZClasses import createZClassForBase

try:
    import CMFNuxDocument
    from Products.CMFCore import utils, CMFCorePermissions
    from Products.CMFCore.DirectoryView import registerDirectory
    _has_cmf = 1
except:
    _has_cmf = 0

 
#createZClassForBase(NuxDocument.NuxDocument, globals(), 
#  'ZNuxDocument', 'NuxDocument')

this_module = sys.modules[__name__]

if _has_cmf:
    contentClasses = (CMFNuxDocument.CMFNuxDocument,)
    contentConstructors = (CMFNuxDocument.addCMFNuxDocument,)
    z_bases = utils.initializeBasesPhase1(contentClasses, this_module)

    # Make the skins available as DirectoryViews
    registerDirectory('skins', globals())
    registerDirectory('skins/NuxDocument', globals())

def initialize(context):
    "Register the (Z/CMF)NuxDocument classes"
    context.registerClass(
        ZNuxDocument.ZNuxDocument,
        permission='Add ZNuxDocuments',
        constructors=(
            ZNuxDocument.addZNuxDocumentForm,
            ZNuxDocument.addZNuxDocument,
        ),
        # icon="www/icon.gif"
    )

    if _has_cmf:
        utils.initializeBasesPhase2(z_bases, context)

        utils.ContentInit("CMF NuxDocument",
            content_types = contentClasses,
            permission = CMFCorePermissions.AddPortalContent,
            extra_constructors = contentConstructors,
            fti = CMFNuxDocument.factory_type_information
        ).initialize(context)


#
# Override default WebDAV PUT mechanism.
# Comment out to get back to default behavior :(
#
import webdav.NullResource
old_PUT_factory = webdav.NullResource.NullResource._default_PUT_factory

def PUT_factory( self, name, typ, body ):
    import plugins

    if plugins.selectPlugin(body, typ) == plugins.getDefaultPlugin():
        ob = old_PUT_factory(self, name, typ, body)
    else:
        ob = ZNuxDocument.ZNuxDocument(id=name, file=body, mime_type=typ)
    return ob

webdav.NullResource.NullResource._default_PUT_factory = PUT_factory

