#
# Copyright 2001-2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import MatcherBase, Plugin, ConversionError, ConverterBase
import os, re, misc


class TextMatcher(MatcherBase):
  acceptable_mime_types = [
    'text/plain',
    ]
  acceptable_file_types = [
    'ASCII text',
    'ISO-8859 text',
    ]
  acceptable_suffixes = [
    'txt',
    ]

class TextConverter(ConverterBase):
  suffix = 'txt'
  mime_type = 'text/plain'

  def getHtml(self):
    return '<pre>' + self.data + '</pre>'

  getBody = getHtml

  def getText(self):
    return self.data


def getPlugins():
  return [
    Plugin('Text', TextMatcher, TextConverter),
    ]
